/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.UniAwait;
import io.smallrye.mutiny.groups.UniCombine;
import io.smallrye.mutiny.groups.UniConvert;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniIfNoItem;
import io.smallrye.mutiny.groups.UniJoin;
import io.smallrye.mutiny.groups.UniMemoize;
import io.smallrye.mutiny.groups.UniOnCancel;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.groups.UniOnItemOrFailure;
import io.smallrye.mutiny.groups.UniOnSubscribe;
import io.smallrye.mutiny.groups.UniOnTerminate;
import io.smallrye.mutiny.groups.UniRepeat;
import io.smallrye.mutiny.groups.UniSubscribe;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Uni<T> {
    public static UniCreate createFrom() {
        return UniCreate.INSTANCE;
    }

    default public <O> O stage(Function<Uni<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    public static UniCombine combine() {
        return UniCombine.INSTANCE;
    }

    public UniSubscribe<T> subscribe();

    default public CompletableFuture<T> subscribeAsCompletionStage() {
        return this.subscribe().asCompletionStage();
    }

    public UniAwait<T> await();

    public UniOnItem<T> onItem();

    @Deprecated
    public UniOnSubscribe<T> onSubscribe();

    public UniOnSubscribe<T> onSubscription();

    public UniOnItemOrFailure<T> onItemOrFailure();

    public UniOnFailure<T> onFailure();

    public UniOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    public UniOnFailure<T> onFailure(Class<? extends Throwable> var1);

    public UniIfNoItem<T> ifNoItem();

    public Uni<T> emitOn(Executor var1);

    public Uni<T> runSubscriptionOn(Executor var1);

    @Experimental(value="Memoization is an experimental feature at this stage")
    public UniMemoize<T> memoize();

    @Deprecated
    default public Uni<T> cache() {
        return this.memoize().indefinitely();
    }

    default public <O> Uni<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().transform(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public Uni<T> invoke(Consumer<? super T> callback) {
        Consumer<? super T> actual = ParameterValidation.nonNull(callback, "callback");
        return this.onItem().invoke(actual);
    }

    default public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.onItem().invoke(actual);
    }

    default public Uni<T> call(Function<? super T, Uni<?>> function) {
        return this.onItem().call(function);
    }

    default public Uni<T> call(Supplier<Uni<?>> supplier) {
        return this.onItem().call(supplier);
    }

    default public <O> Uni<O> flatMap(Function<? super T, Uni<? extends O>> mapper) {
        return this.onItem().transformToUni(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public <O> Uni<O> chain(Function<? super T, Uni<? extends O>> mapper) {
        Function actual = ParameterValidation.nonNull(mapper, "mapper");
        return this.onItem().transformToUni(actual);
    }

    default public <O> Uni<O> chain(Supplier<Uni<? extends O>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.onItem().transformToUni(ignored -> (Uni)actual.get());
    }

    default public Uni<T> eventually(Runnable action) {
        return this.onItemOrFailure().invoke((? super T item, Throwable err) -> ParameterValidation.nonNull(action, "action").run());
    }

    default public <O> Uni<T> eventually(Supplier<Uni<? extends O>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.onItemOrFailure().call((? super T item, Throwable err) -> (Uni)actual.get());
    }

    public UniConvert<T> convert();

    public Multi<T> toMulti();

    public UniRepeat<T> repeat();

    public UniOnTerminate<T> onTermination();

    public UniOnCancel<T> onCancellation();

    default public <R> Uni<R> plug(Function<Uni<T>, Uni<R>> operatorProvider) {
        Function<Uni<Uni>, Uni<R>> provider = ParameterValidation.nonNull(operatorProvider, "operatorProvider");
        return Infrastructure.onUniCreation(ParameterValidation.nonNull(provider.apply(this), "uni"));
    }

    default public <O> Uni<O> replaceWith(O item) {
        return this.onItem().transform(ignore -> item);
    }

    default public <O> Uni<O> replaceWith(Supplier<O> supplier) {
        return this.onItem().transform(ignore -> supplier.get());
    }

    default public <O> Uni<O> replaceWith(Uni<O> uni) {
        return this.onItem().transformToUni(ignore -> uni);
    }

    default public Uni<T> replaceWithNull() {
        return this.onItem().transform(ignore -> null);
    }

    default public Uni<Void> replaceWithVoid() {
        return this.onItem().transform(ignored -> null);
    }

    default public Uni<T> replaceIfNullWith(Supplier<T> supplier) {
        return this.onItem().ifNull().continueWith(supplier);
    }

    default public Uni<T> replaceIfNullWith(T value) {
        return this.onItem().ifNull().continueWith(value);
    }

    public Uni<T> log(String var1);

    public Uni<T> log();

    @Experimental(value="New API based on observations that Uni.combine() is often used with homogeneous types, and combination often just a mapping to a collection.")
    public static UniJoin join() {
        return UniJoin.SHARED_INSTANCE;
    }
}

