/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiConcatOp;
import java.util.ArrayList;
import org.reactivestreams.Publisher;

public class MultiConcat {
    private boolean collectFailures;

    public MultiConcat(boolean collectFailures) {
        this.collectFailures = collectFailures;
    }

    @SafeVarargs
    public final <T> Multi<T> streams(Publisher<T> ... publishers) {
        return Infrastructure.onMultiCreation(new MultiConcatOp<T>(this.collectFailures, publishers));
    }

    public <T> Multi<T> streams(Iterable<? extends Publisher<T>> iterable) {
        ArrayList list = new ArrayList();
        iterable.forEach(list::add);
        return Infrastructure.onMultiCreation(new MultiConcatOp(this.collectFailures, list.toArray(new Publisher[0])));
    }

    public MultiConcat collectFailures() {
        this.collectFailures = true;
        return this;
    }
}

