/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.jwa.CryptoPrimitive;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.jwx.CompactSerializer;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.lang.IntegrityException;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.StringUtil;

public class JsonWebSignature
extends JsonWebStructure {
    public static final short COMPACT_SERIALIZATION_PARTS = 3;
    private byte[] payloadBytes;
    private String payloadCharEncoding = "UTF-8";
    private String encodedPayload;
    private Boolean validSignature;
    private CryptoPrimitive signingPrimitive;

    public JsonWebSignature() {
        if (!Boolean.getBoolean("org.jose4j.jws.default-allow-none")) {
            this.setAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
        }
    }

    @Override
    public void setPayload(String payload) {
        this.payloadBytes = StringUtil.getBytesUnchecked(payload, this.payloadCharEncoding);
    }

    public byte[] getPayloadBytes() throws JoseException {
        if (!this.verifySignature()) {
            throw new IntegrityException("JWS signature is invalid.");
        }
        return this.payloadBytes;
    }

    public byte[] getUnverifiedPayloadBytes() {
        return this.payloadBytes;
    }

    public void setPayloadBytes(byte[] payloadBytes) {
        this.payloadBytes = payloadBytes;
    }

    @Override
    protected void setCompactSerializationParts(String[] parts) throws JoseException {
        if (parts.length != 3) {
            throw new JoseException("A JWS Compact Serialization must have exactly 3 parts separated by period ('.') characters");
        }
        this.setEncodedHeader(parts[0]);
        if (this.isRfc7797UnencodedPayload()) {
            this.setPayload(parts[1]);
        } else {
            this.setEncodedPayload(parts[1]);
        }
        this.setSignature(this.base64url.base64UrlDecode(parts[2]));
    }

    @Override
    public String getCompactSerialization() throws JoseException {
        String payload;
        this.sign();
        if (this.isRfc7797UnencodedPayload()) {
            payload = this.getStringPayload();
            if (payload.contains(".")) {
                throw new JoseException("per https://tools.ietf.org/html/rfc7797#section-5.2 when using the JWS Compact Serialization, unencoded non-detached payloads using period ('.') characters would cause parsing errors; such payloads MUST NOT be used with the JWS Compact Serialization.");
            }
        } else {
            payload = this.getEncodedPayload();
        }
        return CompactSerializer.serialize(this.getEncodedHeader(), payload, this.getEncodedSignature());
    }

    public String getDetachedContentCompactSerialization() throws JoseException {
        this.sign();
        return CompactSerializer.serialize(this.getEncodedHeader(), "", this.getEncodedSignature());
    }

    public CryptoPrimitive prepareSigningPrimitive() throws JoseException {
        this.signingPrimitive = this.createSigningPrimitive();
        return this.signingPrimitive;
    }

    private CryptoPrimitive createSigningPrimitive() throws JoseException {
        JsonWebSignatureAlgorithm algorithm = this.getAlgorithm();
        Key signingKey = this.getKey();
        if (this.isDoKeyValidation()) {
            algorithm.validateSigningKey(signingKey);
        }
        return algorithm.prepareForSign(signingKey, this.getProviderCtx());
    }

    public void sign() throws JoseException {
        CryptoPrimitive cryptoPrimitive = this.signingPrimitive == null ? this.createSigningPrimitive() : this.signingPrimitive;
        byte[] inputBytes = this.getSigningInputBytes();
        byte[] signatureBytes = this.getAlgorithm().sign(cryptoPrimitive, inputBytes);
        this.setSignature(signatureBytes);
    }

    @Override
    protected void onNewKey() {
        this.validSignature = null;
    }

    public boolean verifySignature() throws JoseException {
        JsonWebSignatureAlgorithm algorithm = this.getAlgorithm();
        Key verificationKey = this.getKey();
        if (this.isDoKeyValidation()) {
            algorithm.validateVerificationKey(verificationKey);
        }
        if (this.validSignature == null) {
            this.checkCrit();
            byte[] signatureBytes = this.getSignature();
            byte[] inputBytes = this.getSigningInputBytes();
            this.validSignature = algorithm.verifySignature(signatureBytes, verificationKey, inputBytes, this.getProviderCtx());
        }
        return this.validSignature;
    }

    @Override
    protected boolean isSupportedCriticalHeader(String headerName) {
        return "b64".equals(headerName);
    }

    @Override
    public JsonWebSignatureAlgorithm getAlgorithm() throws InvalidAlgorithmException {
        return this.getAlgorithm(true);
    }

    @Override
    public JsonWebSignatureAlgorithm getAlgorithmNoConstraintCheck() throws InvalidAlgorithmException {
        return this.getAlgorithm(false);
    }

    private JsonWebSignatureAlgorithm getAlgorithm(boolean checkConstraints) throws InvalidAlgorithmException {
        String algo = this.getAlgorithmHeaderValue();
        if (algo == null) {
            throw new InvalidAlgorithmException("Signature algorithm header (alg) not set.");
        }
        if (checkConstraints) {
            this.getAlgorithmConstraints().checkConstraint(algo);
        }
        AlgorithmFactoryFactory factoryFactory = AlgorithmFactoryFactory.getInstance();
        AlgorithmFactory<JsonWebSignatureAlgorithm> jwsAlgorithmFactory = factoryFactory.getJwsAlgorithmFactory();
        return jwsAlgorithmFactory.getAlgorithm(algo);
    }

    private byte[] getSigningInputBytes() throws JoseException {
        if (!this.isRfc7797UnencodedPayload()) {
            String signingInputString = CompactSerializer.serialize(this.getEncodedHeader(), this.getEncodedPayload());
            return StringUtil.getBytesAscii(signingInputString);
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(StringUtil.getBytesAscii(this.getEncodedHeader()));
            os.write(46);
            os.write(this.payloadBytes);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new JoseException("This should never happen from a ByteArrayOutputStream", e);
        }
    }

    protected boolean isRfc7797UnencodedPayload() {
        Object b64 = this.headers.getObjectHeaderValue("b64");
        return b64 != null && b64 instanceof Boolean && (Boolean)b64 == false;
    }

    @Override
    public String getPayload() throws JoseException {
        if (!Boolean.getBoolean("org.jose4j.jws.getPayload-skip-verify") && !this.verifySignature()) {
            throw new IntegrityException("JWS signature is invalid.");
        }
        return this.getStringPayload();
    }

    public String getUnverifiedPayload() {
        return this.getStringPayload();
    }

    private String getStringPayload() {
        return StringUtil.newString(this.payloadBytes, this.payloadCharEncoding);
    }

    public String getPayloadCharEncoding() {
        return this.payloadCharEncoding;
    }

    public void setPayloadCharEncoding(String payloadCharEncoding) {
        this.payloadCharEncoding = payloadCharEncoding;
    }

    public String getKeyType() throws InvalidAlgorithmException {
        return this.getAlgorithmNoConstraintCheck().getKeyType();
    }

    public KeyPersuasion getKeyPersuasion() throws InvalidAlgorithmException {
        return this.getAlgorithmNoConstraintCheck().getKeyPersuasion();
    }

    public void setEncodedPayload(String encodedPayload) {
        this.encodedPayload = encodedPayload;
        this.payloadBytes = this.base64url.base64UrlDecode(encodedPayload);
    }

    public String getEncodedPayload() {
        return this.encodedPayload != null ? this.encodedPayload : this.base64url.base64UrlEncode(this.payloadBytes);
    }

    public String getEncodedSignature() {
        return this.base64url.base64UrlEncode(this.getSignature());
    }

    protected byte[] getSignature() {
        return this.getIntegrity();
    }

    protected void setSignature(byte[] signature) {
        this.setIntegrity(signature);
    }
}

