/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.util.BeginInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.ByteString;

public class NonTxPutFromLoadInterceptor
extends BaseCustomAsyncInterceptor {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(NonTxPutFromLoadInterceptor.class);
    private final ByteString cacheName;
    private final PutFromLoadValidator putFromLoadValidator;
    @Inject
    RpcManager rpcManager;

    public NonTxPutFromLoadInterceptor(PutFromLoadValidator putFromLoadValidator, ByteString cacheName) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.cacheName = cacheName;
    }

    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) {
        if (!ctx.isOriginLocal() && command instanceof BeginInvalidationCommand) {
            for (Object key : command.getKeys()) {
                this.putFromLoadValidator.beginInvalidatingKey(((BeginInvalidationCommand)command).getLockOwner(), key);
            }
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public void endInvalidating(Object key, Object lockOwner, boolean successful) {
        assert (lockOwner != null);
        if (!this.putFromLoadValidator.endInvalidatingKey(lockOwner, key, successful)) {
            log.failedEndInvalidating(key, this.cacheName);
        }
        this.rpcManager.sendToAll((ReplicableCommand)new EndInvalidationCommand(this.cacheName, new Object[]{key}, lockOwner), DeliverOrder.NONE);
    }
}

