/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.EventLoop;
import java.io.IOException;
import java.net.SocketAddress;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.XnioEventLoop;

public final class XnioServerSocketChannel
extends AbstractXnioServerSocketChannel {
    private final OptionMap.Builder options = OptionMap.builder();
    private volatile AcceptingChannel channel;

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof XnioEventLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBind(SocketAddress localAddress) throws Exception {
        XnioWorker worker = ((XnioEventLoop)this.eventLoop()).ioThread().getWorker();
        OptionMap map = this.options.set(Options.WORKER_IO_THREADS, worker.getIoThreadCount()).getMap();
        XnioEventLoop eventLoop = (XnioEventLoop)this.eventLoop();
        XnioServerSocketChannel xnioServerSocketChannel = this;
        synchronized (xnioServerSocketChannel) {
            this.channel = eventLoop.ioThread().getWorker().createStreamConnectionServer(localAddress, (ChannelListener)new AbstractXnioServerSocketChannel.AcceptListener(this), map);
            this.channel.resumeAccepts();
        }
    }

    @Override
    protected <T> T getOption0(Option<T> option) throws IOException {
        if (this.channel != null) {
            return (T)this.channel.getOption(option);
        }
        return (T)this.options.getMap().get(option);
    }

    @Override
    protected synchronized <T> void setOption0(Option<T> option, T value) throws IOException {
        if (this.channel != null) {
            this.channel.setOption(option, value);
        } else {
            this.options.set(option, value);
        }
    }

    @Override
    protected AcceptingChannel xnioChannel() {
        return this.channel;
    }
}

