/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.locators.JBossPolicyLocator;
import org.jboss.security.xacml.locators.JBossPolicySetLocator;

public class JBossXACMLUtil {
    public PolicyDecisionPoint getPDP(PolicyRegistration policyRegistration, String contextID) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("PDP", "PDP");
        PolicyDecisionPoint pdp = null;
        try {
            pdp = (PolicyDecisionPoint)policyRegistration.getPolicy(contextID, "XACML", contextMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pdp == null) {
            Set policies = (Set)policyRegistration.getPolicy(contextID, "XACML", null);
            if (policies == null) {
                throw PicketBoxMessages.MESSAGES.missingXACMLPolicyForContextId(contextID);
            }
            JBossPolicyLocator jpl = new JBossPolicyLocator(policies);
            JBossPolicySetLocator jpsl = new JBossPolicySetLocator(policies);
            HashSet<Object> plset = new HashSet<Object>();
            plset.add(jpl);
            plset.add(jpsl);
            pdp = new JBossPDP();
            pdp.setPolicies(policies);
            pdp.setLocators(plset);
        }
        return pdp;
    }
}

