/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContextAssociation;

class GetPrincipalInfoAction {
    GetPrincipalInfoAction() {
    }

    private static char[] getPassword() {
        Object credential = SecurityContextAssociation.getCredential();
        char[] password = null;
        if (credential instanceof char[]) {
            password = (char[])credential;
        } else if (credential instanceof byte[]) {
            try {
                String tmp = new String((byte[])credential, "UTF-8");
                password = tmp.toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                throw new SecurityException(e.getMessage());
            }
        } else if (credential != null) {
            String tmp = credential.toString();
            password = tmp.toCharArray();
        }
        return password;
    }

    static Principal getPrincipal() {
        Principal principal = System.getSecurityManager() == null ? PrincipalActions.NON_PRIVILEGED.getPrincipal() : PrincipalActions.PRIVILEGED.getPrincipal();
        return principal;
    }

    static char[] getCredential() {
        char[] credential = System.getSecurityManager() == null ? PrincipalActions.NON_PRIVILEGED.getCredential() : PrincipalActions.PRIVILEGED.getCredential();
        return credential;
    }

    static RunAsIdentity peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return (RunAsIdentity)PrincipalActions.NON_PRIVILEGED.peek();
        }
        return (RunAsIdentity)PrincipalActions.PRIVILEGED.peek();
    }

    static interface PrincipalActions {
        public static final PrincipalActions PRIVILEGED = new PrincipalActions(){
            private final PrivilegedAction<RunAs> peekAction = new PrivilegedAction<RunAs>(){

                @Override
                public RunAs run() {
                    return SecurityContextAssociation.peekRunAsIdentity();
                }
            };
            private final PrivilegedAction<Principal> getPrincipalAction = new PrivilegedAction<Principal>(){

                @Override
                public Principal run() {
                    return SecurityContextAssociation.getPrincipal();
                }
            };
            private final PrivilegedAction<Object> getCredentialAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return GetPrincipalInfoAction.getPassword();
                }
            };

            @Override
            public RunAsIdentity peek() {
                return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
            }

            @Override
            public Principal getPrincipal() {
                return AccessController.doPrivileged(this.getPrincipalAction);
            }

            @Override
            public char[] getCredential() {
                return (char[])AccessController.doPrivileged(this.getCredentialAction);
            }
        };
        public static final PrincipalActions NON_PRIVILEGED = new PrincipalActions(){

            @Override
            public RunAs peek() {
                return SecurityContextAssociation.peekRunAsIdentity();
            }

            @Override
            public Principal getPrincipal() {
                return SecurityContextAssociation.getPrincipal();
            }

            @Override
            public char[] getCredential() {
                return GetPrincipalInfoAction.getPassword();
            }
        };

        public Principal getPrincipal();

        public char[] getCredential();

        public RunAs peek();
    }
}

