/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public final class FieldValueQuery
extends Query {
    private final String field;

    public FieldValueQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FieldValueQuery that = (FieldValueQuery)obj;
        return this.field.equals(that.field);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.field.hashCode();
    }

    @Override
    public String toString(String field) {
        return "FieldValueQuery [field=" + this.field + "]" + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                return context.reader().getDocsWithField(FieldValueQuery.this.field);
            }
        };
    }
}

