/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.definition.DefinitionConstant;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.CustomSchemaRegistry;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import io.smallrye.openapi.runtime.scanner.ScannerMessages;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class OpenApiAnnotationScanner {
    private final AnnotationScannerContext annotationScannerContext;
    private final AnnotationScannerFactory annotationScannerFactory;

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, Collections.singletonList(new AnnotationScannerExtension(){}));
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index, List<AnnotationScannerExtension> extensions) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, extensions);
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index) {
        this(config, loader, index, Collections.singletonList(new AnnotationScannerExtension(){}));
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, List<AnnotationScannerExtension> extensions) {
        FilteredIndexView filteredIndexView = index instanceof FilteredIndexView ? (FilteredIndexView)FilteredIndexView.class.cast(index) : new FilteredIndexView(index, config);
        this.annotationScannerContext = new AnnotationScannerContext(filteredIndexView, loader, extensions, config, new OpenAPIImpl());
        this.annotationScannerFactory = new AnnotationScannerFactory(loader);
    }

    public OpenAPI scan(String ... filter) {
        OpenAPI openApi = this.scanMicroProfileOpenApiAnnotations();
        List<AnnotationScanner> annotationScanners = this.annotationScannerFactory.getAnnotationScanners();
        for (AnnotationScanner annotationScanner : annotationScanners) {
            if (filter != null && filter.length != 0 && !Arrays.asList(filter).contains(annotationScanner.getName())) continue;
            ScannerLogging.logger.scanning(annotationScanner.getName());
            CurrentScannerInfo.register(annotationScanner);
            openApi = annotationScanner.scan(this.annotationScannerContext, openApi);
        }
        this.sortTags(this.annotationScannerContext, openApi);
        this.sortMaps(openApi);
        return openApi;
    }

    private OpenAPI scanMicroProfileOpenApiAnnotations() {
        OpenAPI openApi = this.annotationScannerContext.getOpenApi();
        openApi.setOpenapi("3.0.3");
        SchemaRegistry schemaRegistry = SchemaRegistry.newInstance(this.annotationScannerContext);
        this.getCustomSchemaRegistry(this.annotationScannerContext.getConfig()).registerCustomSchemas(schemaRegistry);
        ScannerLogging.logger.scanning("OpenAPI");
        this.processPackageOpenAPIDefinitions(this.annotationScannerContext, openApi);
        this.processClassSchemas(this.annotationScannerContext);
        return openApi;
    }

    private OpenAPI processPackageOpenAPIDefinitions(AnnotationScannerContext context, OpenAPI oai) {
        List packageDefs = context.getIndex().getAnnotations(DefinitionConstant.DOTNAME_OPEN_API_DEFINITION).stream().filter(this::annotatedClasses).filter(annotation -> annotation.target().asClass().name().withoutPackagePrefix().equals("package-info")).collect(Collectors.toList());
        for (AnnotationInstance packageDef : packageDefs) {
            OpenAPIImpl packageOai = new OpenAPIImpl();
            DefinitionReader.processDefinition(context, packageOai, packageDef);
            oai = MergeUtil.merge(oai, packageOai);
        }
        return oai;
    }

    private CustomSchemaRegistry getCustomSchemaRegistry(OpenApiConfig config) {
        if (config == null || config.customSchemaRegistryClass() == null) {
            return type -> {};
        }
        try {
            return (CustomSchemaRegistry)Class.forName(config.customSchemaRegistryClass(), true, this.annotationScannerContext.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw ScannerMessages.msg.failedCreateInstance(config.customSchemaRegistryClass(), ex);
        }
    }

    private void processClassSchemas(AnnotationScannerContext context) {
        CurrentScannerInfo.register(null);
        context.getIndex().getAnnotations(SchemaConstant.DOTNAME_SCHEMA).stream().filter(this::annotatedClasses).map(annotation -> Type.create((DotName)annotation.target().asClass().name(), (Type.Kind)Type.Kind.CLASS)).forEach(type -> SchemaFactory.typeToSchema(context, type, context.getExtensions()));
    }

    private boolean annotatedClasses(AnnotationInstance annotation) {
        return Objects.equals(annotation.target().kind(), AnnotationTarget.Kind.CLASS);
    }

    private void sortTags(AnnotationScannerContext context, OpenAPI oai) {
        List tags = oai.getTags();
        if (tags != null && !tags.isEmpty() && !this.tagsDefinedByOpenAPIDefinition(context)) {
            oai.setTags(tags.stream().sorted(Comparator.comparing(Tag::getName)).collect(Collectors.toList()));
        }
    }

    private boolean tagsDefinedByOpenAPIDefinition(AnnotationScannerContext context) {
        return context.getIndex().getAnnotations(DefinitionConstant.DOTNAME_OPEN_API_DEFINITION).stream().filter(a -> a.value("tags") != null).map(a -> a.value("tags").asNestedArray()).anyMatch(definitionTags -> ((AnnotationInstance[])definitionTags).length > 0);
    }

    private void sortMaps(OpenAPI oai) {
        this.sort(oai.getPaths(), Paths::getPathItems, Paths::setPathItems);
        Components components = oai.getComponents();
        this.sort(components, Components::getCallbacks, Components::setCallbacks);
        this.sort(components, Components::getExamples, Components::setExamples);
        this.sort(components, Components::getHeaders, Components::setHeaders);
        this.sort(components, Components::getLinks, Components::setLinks);
        this.sort(components, Components::getParameters, Components::setParameters);
        this.sort(components, Components::getRequestBodies, Components::setRequestBodies);
        this.sort(components, Components::getResponses, Components::setResponses);
        this.sort(components, Components::getSchemas, Components::setSchemas);
        this.sort(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
    }

    private <P, V> void sort(P parent, Function<P, Map<String, V>> source, BiConsumer<P, Map<String, V>> target) {
        if (parent == null) {
            return;
        }
        Map<String, V> unsorted = source.apply(parent);
        if (unsorted == null || unsorted.isEmpty()) {
            return;
        }
        Map sorted = unsorted.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        target.accept(parent, sorted);
    }
}

