/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.DigestAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JDBCProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.MulticastProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PlainAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketDiscoveryProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketTransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportRegistration;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.XMLAttribute;
import org.jboss.as.clustering.jgroups.subsystem.XMLElement;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JGroupsSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(JGroupsSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined(ChannelResourceDefinition.WILDCARD_PATH.getKey())) {
                writer.writeStartElement(XMLElement.CHANNELS.getLocalName());
                JGroupsSubsystemXMLWriter.writeAttribute(writer, model, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL);
                for (Property property : model.get(ChannelResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(XMLElement.CHANNEL.getLocalName());
                    writer.writeAttribute(XMLAttribute.NAME.getLocalName(), property.getName());
                    ModelNode channel = property.getValue();
                    JGroupsSubsystemXMLWriter.writeAttributes(writer, channel, ChannelResourceDefinition.Attribute.class);
                    if (channel.hasDefined(ForkResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property forkProperty : channel.get(ForkResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            writer.writeStartElement(XMLElement.FORK.getLocalName());
                            writer.writeAttribute(XMLAttribute.NAME.getLocalName(), forkProperty.getName());
                            ModelNode fork = forkProperty.getValue();
                            if (fork.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                                for (Property protocol : fork.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                                    JGroupsSubsystemXMLWriter.writeProtocol(writer, protocol);
                                }
                            }
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (model.hasDefined(StackResourceDefinition.WILDCARD_PATH.getKey())) {
                writer.writeStartElement(XMLElement.STACKS.getLocalName());
                JGroupsSubsystemXMLWriter.writeAttribute(writer, model, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK);
                for (Property property : model.get(StackResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(XMLElement.STACK.getLocalName());
                    writer.writeAttribute(XMLAttribute.NAME.getLocalName(), property.getName());
                    ModelNode stack = property.getValue();
                    JGroupsSubsystemXMLWriter.writeAttributes(writer, stack, StackResourceDefinition.Attribute.class);
                    if (stack.hasDefined(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
                        JGroupsSubsystemXMLWriter.writeTransport(writer, stack.get(TransportResourceDefinition.WILDCARD_PATH.getKey()).asProperty());
                    }
                    if (stack.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property protocol : stack.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            JGroupsSubsystemXMLWriter.writeProtocol(writer, protocol);
                        }
                    }
                    if (stack.get(RelayResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                        JGroupsSubsystemXMLWriter.writeRelay(writer, stack.get(RelayResourceDefinition.PATH.getKeyValuePair()));
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeTransport(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(XMLElement.TRANSPORT.getLocalName());
        JGroupsSubsystemXMLWriter.writeGenericProtocolAttributes(writer, property);
        ModelNode transport = property.getValue();
        JGroupsSubsystemXMLWriter.writeAttributes(writer, transport, TransportResourceDefinition.Attribute.class);
        JGroupsSubsystemXMLWriter.writeAttributes(writer, transport, TransportResourceDefinition.ThreadingAttribute.class);
        if (JGroupsSubsystemXMLWriter.containsName(TransportRegistration.SocketTransport.class, property.getName())) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), SocketTransportResourceDefinition.Attribute.class);
        }
        JGroupsSubsystemXMLWriter.writeElement(writer, transport, AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
        JGroupsSubsystemXMLWriter.writeThreadPoolElements(XMLElement.DEFAULT_THREAD_POOL, ThreadPoolResourceDefinition.DEFAULT, writer, transport);
        writer.writeEndElement();
    }

    private static void writeProtocol(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(XMLElement.forProtocolName(property).getLocalName());
        JGroupsSubsystemXMLWriter.writeProtocolAttributes(writer, property);
        JGroupsSubsystemXMLWriter.writeElement(writer, property.getValue(), AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
        writer.writeEndElement();
    }

    private static void writeGenericProtocolAttributes(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(XMLAttribute.TYPE.getLocalName(), property.getName());
        JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.complementOf(EnumSet.of(AbstractProtocolResourceDefinition.Attribute.PROPERTIES)));
    }

    private static void writeProtocolAttributes(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        JGroupsSubsystemXMLWriter.writeGenericProtocolAttributes(writer, property);
        String protocol = property.getName();
        if (JGroupsSubsystemXMLWriter.containsName(ProtocolRegistration.MulticastProtocol.class, protocol)) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), MulticastProtocolResourceDefinition.Attribute.class);
        } else if (JGroupsSubsystemXMLWriter.containsName(ProtocolRegistration.SocketProtocol.class, protocol)) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), SocketProtocolResourceDefinition.Attribute.class);
        } else if (JGroupsSubsystemXMLWriter.containsName(ProtocolRegistration.JdbcProtocol.class, protocol)) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), JDBCProtocolResourceDefinition.Attribute.class);
        } else if (JGroupsSubsystemXMLWriter.containsName(ProtocolRegistration.EncryptProtocol.class, protocol)) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EncryptProtocolResourceDefinition.Attribute.class);
        } else if (JGroupsSubsystemXMLWriter.containsName(ProtocolRegistration.InitialHostsProtocol.class, protocol)) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), SocketDiscoveryProtocolResourceDefinition.Attribute.class);
        } else if (JGroupsSubsystemXMLWriter.containsName(ProtocolRegistration.AuthProtocol.class, protocol)) {
            JGroupsSubsystemXMLWriter.writeAuthToken(writer, property.getValue().get(AuthTokenResourceDefinition.WILDCARD_PATH.getKey()).asProperty());
        } else {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), GenericProtocolResourceDefinition.DeprecatedAttribute.class);
        }
    }

    private static <E extends Enum<E>> boolean containsName(Class<E> enumClass, String name) {
        for (Enum protocol : EnumSet.allOf(enumClass)) {
            if (!name.equals(protocol.name())) continue;
            return true;
        }
        return false;
    }

    private static void writeAuthToken(XMLExtendedStreamWriter writer, Property token) throws XMLStreamException {
        writer.writeStartElement(XMLElement.forAuthTokenName(token.getName()).getLocalName());
        if (PlainAuthTokenResourceDefinition.PATH.getValue().equals(token.getName())) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, token.getValue(), AuthTokenResourceDefinition.Attribute.class);
        }
        if (DigestAuthTokenResourceDefinition.PATH.getValue().equals(token.getName())) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, token.getValue(), Stream.concat(EnumSet.allOf(AuthTokenResourceDefinition.Attribute.class).stream(), EnumSet.allOf(DigestAuthTokenResourceDefinition.Attribute.class).stream()));
        }
        if (CipherAuthTokenResourceDefinition.PATH.getValue().equals(token.getName())) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, token.getValue(), Stream.concat(EnumSet.allOf(AuthTokenResourceDefinition.Attribute.class).stream(), EnumSet.allOf(CipherAuthTokenResourceDefinition.Attribute.class).stream()));
        }
        writer.writeEndElement();
    }

    private static void writeThreadPoolElements(XMLElement element, ThreadPoolResourceDefinition pool, XMLExtendedStreamWriter writer, ModelNode transport) throws XMLStreamException {
        ModelNode threadPool;
        PathElement path = pool.getPathElement();
        if (transport.get(path.getKey()).hasDefined(path.getValue()) && JGroupsSubsystemXMLWriter.hasDefined(threadPool = transport.get(path.getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            JGroupsSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private static void writeRelay(XMLExtendedStreamWriter writer, ModelNode relay) throws XMLStreamException {
        writer.writeStartElement(XMLElement.RELAY.getLocalName());
        JGroupsSubsystemXMLWriter.writeAttributes(writer, relay, RelayResourceDefinition.Attribute.class);
        if (relay.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(XMLElement.REMOTE_SITE.getLocalName());
                writer.writeAttribute(XMLAttribute.NAME.getLocalName(), property.getName());
                JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.allOf(RemoteSiteResourceDefinition.Attribute.class));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static boolean hasDefined(ModelNode model, Collection<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (!model.hasDefined(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private static <A extends Enum<A>> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        JGroupsSubsystemXMLWriter.writeAttributes(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Collection<? extends Attribute> attributes) throws XMLStreamException {
        JGroupsSubsystemXMLWriter.writeAttributes(writer, model, attributes.stream());
    }

    private static <A extends Attribute> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Stream<A> stream) throws XMLStreamException {
        Stream.Builder<Attribute> objectAttributes = Stream.builder();
        Iterable attributes = stream::iterator;
        for (Attribute attribute : attributes) {
            if (((AttributeDefinition)attribute.getDefinition()).getType() == ModelType.OBJECT) {
                objectAttributes.add(attribute);
                continue;
            }
            JGroupsSubsystemXMLWriter.writeAttribute(writer, model, attribute);
        }
        Iterable elementAttributes = objectAttributes.build()::iterator;
        for (Attribute attribute : elementAttributes) {
            JGroupsSubsystemXMLWriter.writeElement(writer, model, attribute);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsAttribute((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsElement((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }
}

