/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.handlers;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.UniqueTypeValidationStepHandler;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerAddHandler;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerTypeEnum;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class HandlerResourceDefinition
extends AbstractFederationResourceDefinition {
    public static final SimpleAttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_CLASS_NAME.getName(), ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{ModelElement.COMMON_CODE.getName()})).build();
    public static final SimpleAttributeDefinition CODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_CODE.getName(), ModelType.STRING, true).setValidator((ParameterValidator)new EnumValidator(HandlerTypeEnum.class, true, true))).setAllowExpression(true)).setAlternatives(new String[]{ModelElement.COMMON_CLASS_NAME.getName()})).build();
    public static final HandlerResourceDefinition INSTANCE = new HandlerResourceDefinition();

    private HandlerResourceDefinition() {
        super(ModelElement.COMMON_HANDLER, HandlerAddHandler.INSTANCE, CLASS_NAME, CODE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(HandlerParameterResourceDefinition.INSTANCE, resourceRegistration);
    }

    public static String getHandlerType(OperationContext context, ModelNode elementNode) throws OperationFailedException {
        ModelNode classNameNode = CLASS_NAME.resolveModelAttribute(context, elementNode);
        ModelNode codeNode = CODE.resolveModelAttribute(context, elementNode);
        if (classNameNode.isDefined()) {
            return classNameNode.asString();
        }
        if (codeNode.isDefined()) {
            return HandlerTypeEnum.forType(codeNode.asString());
        }
        throw PicketLinkLogger.ROOT_LOGGER.federationHandlerTypeNotProvided();
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        return new ModelOnlyWriteAttributeHandler(this.getAttributes().toArray(new AttributeDefinition[0])){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)new UniqueTypeValidationStepHandler(ModelElement.COMMON_HANDLER){

                    @Override
                    protected String getType(OperationContext context, ModelNode model) throws OperationFailedException {
                        return HandlerResourceDefinition.getHandlerType(context, model);
                    }
                }, OperationContext.Stage.MODEL);
                super.execute(context, operation);
            }
        };
    }
}

