/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadata;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadataContainer;
import org.jboss.as.weld.deployment.PropertyReplacingBeansXmlParser;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;

public class BeansXmlProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        VirtualFile rootBeansXml;
        VirtualFile beansXml;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        HashMap<ResourceRoot, ExplicitBeanArchiveMetadata> beanArchiveMetadata = new HashMap<ResourceRoot, ExplicitBeanArchiveMetadata>();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot == null) {
            return;
        }
        PropertyReplacingBeansXmlParser parser = new PropertyReplacingBeansXmlParser(deploymentUnit);
        ResourceRoot classesRoot = null;
        List structure = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : structure) {
            if (!ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot)) continue;
            if (resourceRoot.getRootName().equals("classes")) {
                classesRoot = resourceRoot;
                deploymentUnit.putAttachment(WeldAttachments.CLASSES_RESOURCE_ROOT, (Object)resourceRoot);
                continue;
            }
            beansXml = resourceRoot.getRoot().getChild(META_INF_BEANS_XML);
            if (!beansXml.exists() || !beansXml.isFile()) continue;
            WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", (Object)beansXml.toString());
            beanArchiveMetadata.put(resourceRoot, new ExplicitBeanArchiveMetadata(beansXml, resourceRoot, this.parseBeansXml(beansXml, parser, deploymentUnit), false));
        }
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            boolean beansXmlPresent;
            rootBeansXml = deploymentRoot.getRoot().getChild(WEB_INF_BEANS_XML);
            boolean rootBeansXmlPresent = rootBeansXml.exists() && rootBeansXml.isFile();
            beansXml = null;
            if (classesRoot != null) {
                beansXml = classesRoot.getRoot().getChild(META_INF_BEANS_XML);
            }
            boolean bl = beansXmlPresent = beansXml != null && beansXml.exists() && beansXml.isFile();
            if (rootBeansXmlPresent) {
                if (beansXmlPresent) {
                    WeldLogger.DEPLOYMENT_LOGGER.duplicateBeansXml();
                    beanArchiveMetadata.put(deploymentRoot, new ExplicitBeanArchiveMetadata(rootBeansXml, beansXml, classesRoot, this.parseBeansXml(rootBeansXml, parser, deploymentUnit), true));
                } else {
                    WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", (Object)rootBeansXml);
                    beanArchiveMetadata.put(deploymentRoot, new ExplicitBeanArchiveMetadata(rootBeansXml, classesRoot, this.parseBeansXml(rootBeansXml, parser, deploymentUnit), true));
                }
            } else if (beansXmlPresent) {
                WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", (Object)beansXml);
                beanArchiveMetadata.put(deploymentRoot, new ExplicitBeanArchiveMetadata(beansXml, classesRoot, this.parseBeansXml(beansXml, parser, deploymentUnit), true));
            }
        } else if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit) && (rootBeansXml = deploymentRoot.getRoot().getChild(META_INF_BEANS_XML)).exists() && rootBeansXml.isFile()) {
            WeldLogger.DEPLOYMENT_LOGGER.debugf("Found beans.xml: %s", (Object)rootBeansXml.toString());
            beanArchiveMetadata.put(deploymentRoot, new ExplicitBeanArchiveMetadata(rootBeansXml, deploymentRoot, this.parseBeansXml(rootBeansXml, parser, deploymentUnit), true));
        }
        if (!beanArchiveMetadata.isEmpty()) {
            ExplicitBeanArchiveMetadataContainer deploymentMetadata = new ExplicitBeanArchiveMetadataContainer(beanArchiveMetadata);
            deploymentUnit.putAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY, (Object)deploymentMetadata);
            Iterator iterator = beanArchiveMetadata.entrySet().iterator();
            while (iterator.hasNext()) {
                if (BeanDiscoveryMode.NONE == ((ExplicitBeanArchiveMetadata)iterator.next().getValue()).getBeansXml().getBeanDiscoveryMode()) continue;
                WeldDeploymentMarker.mark(deploymentUnit);
                break;
            }
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(WeldAttachments.CLASSES_RESOURCE_ROOT);
        deploymentUnit.removeAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY);
    }

    private BeansXml parseBeansXml(VirtualFile beansXmlFile, PropertyReplacingBeansXmlParser parser, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        try {
            return parser.parse(beansXmlFile.asFileURL());
        }
        catch (MalformedURLException e) {
            throw WeldLogger.ROOT_LOGGER.couldNotGetBeansXmlAsURL(beansXmlFile.toString(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }
}

