/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.EJBClientDescriptor11Parser;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLAttribute;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLElement;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor12Parser
extends EJBClientDescriptor11Parser {
    public static final String NAMESPACE_1_2 = "urn:jboss:ejb-client:1.2";

    protected EJBClientDescriptor12Parser(PropertyReplacer propertyReplacer) {
        super(propertyReplacer);
    }

    @Override
    protected void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case INVOCATION_TIMEOUT: {
                    long invocationTimeout = Long.parseLong(value);
                    ejbClientDescriptorMetaData.setInvocationTimeout(invocationTimeout);
                    continue block12;
                }
                case DEPLOYMENT_NODE_SELECTOR: {
                    ejbClientDescriptorMetaData.setDeploymentNodeSelector(value);
                    continue block12;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        EnumSet<EJBClientDescriptorXMLElement> visited = EnumSet.noneOf(EJBClientDescriptorXMLElement.class);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor12Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block13;
                        }
                        case CLUSTERS: {
                            this.parseClusters(reader, ejbClientDescriptorMetaData);
                            continue block13;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block13;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    @Override
    protected void parseRemotingReceiver(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        String outboundConnectionRef = null;
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.OUTBOUND_CONNECTION_REF);
        int count = reader.getAttributeCount();
        EJBClientDescriptorMetaData.RemotingReceiverConfiguration remotingReceiverConfiguration = null;
        long connectTimeout = 5000L;
        block11: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case OUTBOUND_CONNECTION_REF: {
                    outboundConnectionRef = value;
                    remotingReceiverConfiguration = ejbClientDescriptorMetaData.addRemotingReceiverConnectionRef(outboundConnectionRef);
                    continue block11;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block11;
                }
                default: {
                    EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor12Parser.missingAttributes(reader.getLocation(), required);
        }
        remotingReceiverConfiguration.setConnectionTimeout(connectTimeout);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            remotingReceiverConfiguration.setChannelCreationOptions(channelCreationOptions);
                            continue block12;
                        }
                    }
                    EJBClientDescriptor12Parser.unexpectedElement(reader);
                    continue block12;
                }
            }
            EJBClientDescriptor12Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor12Parser.unexpectedEndOfDocument(reader.getLocation());
    }
}

