/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.bulkhead;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.FutureCancellationEvent;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadBase;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadEvents;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadLogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FutureThreadPoolBulkhead<V>
extends BulkheadBase<Future<V>> {
    private final int queueSize;
    private final Semaphore capacitySemaphore;
    private final Semaphore workSemaphore;

    public FutureThreadPoolBulkhead(FaultToleranceStrategy<Future<V>> delegate, String description, int size, int queueSize) {
        super(description, delegate);
        this.queueSize = queueSize;
        this.capacitySemaphore = new Semaphore(size + queueSize, true);
        this.workSemaphore = new Semaphore(size, true);
    }

    @Override
    public Future<V> apply(InvocationContext<Future<V>> ctx) throws Exception {
        BulkheadLogger.LOG.trace("ThreadPoolBulkhead started");
        try {
            Future<V> future = this.doApply(ctx);
            return future;
        }
        finally {
            BulkheadLogger.LOG.trace("ThreadPoolBulkhead finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<V> doApply(InvocationContext<Future<V>> ctx) throws Exception {
        if (this.capacitySemaphore.tryAcquire()) {
            BulkheadLogger.LOG.trace("Capacity semaphore acquired, accepting task into bulkhead");
            ctx.fireEvent(BulkheadEvents.DecisionMade.ACCEPTED);
            ctx.fireEvent(BulkheadEvents.StartedWaiting.INSTANCE);
            AtomicBoolean cancellationInvalid = new AtomicBoolean(false);
            AtomicBoolean cancelled = new AtomicBoolean(false);
            AtomicReference<Thread> executingThread = new AtomicReference<Thread>(Thread.currentThread());
            ctx.registerEventHandler(FutureCancellationEvent.class, event -> {
                if (cancellationInvalid.get()) {
                    return;
                }
                if (BulkheadLogger.LOG.isTraceEnabled()) {
                    BulkheadLogger.LOG.trace("Cancelling bulkhead task," + (event.interruptible ? "" : " NOT") + " interrupting executing thread");
                }
                cancelled.set(true);
                if (event.interruptible) {
                    ((Thread)executingThread.get()).interrupt();
                }
            });
            try {
                this.workSemaphore.acquire();
                BulkheadLogger.LOG.trace("Work semaphore acquired, running task");
            }
            catch (InterruptedException e) {
                cancellationInvalid.set(true);
                this.capacitySemaphore.release();
                BulkheadLogger.LOG.trace("Capacity semaphore released, task leaving bulkhead");
                ctx.fireEvent(BulkheadEvents.FinishedWaiting.INSTANCE);
                throw new CancellationException();
            }
            ctx.fireEvent(BulkheadEvents.FinishedWaiting.INSTANCE);
            ctx.fireEvent(BulkheadEvents.StartedRunning.INSTANCE);
            try {
                if (cancelled.get()) {
                    throw new CancellationException();
                }
                Future<V> future = this.delegate.apply(ctx);
                return future;
            }
            finally {
                cancellationInvalid.set(true);
                this.workSemaphore.release();
                BulkheadLogger.LOG.trace("Work semaphore released, task finished");
                this.capacitySemaphore.release();
                BulkheadLogger.LOG.trace("Capacity semaphore released, task leaving bulkhead");
                ctx.fireEvent(BulkheadEvents.FinishedRunning.INSTANCE);
            }
        }
        BulkheadLogger.LOG.trace("Capacity semaphore not acquired, rejecting task from bulkhead");
        ctx.fireEvent(BulkheadEvents.DecisionMade.REJECTED);
        throw this.bulkheadRejected();
    }

    int getQueueSize() {
        return Math.max(0, this.queueSize - this.capacitySemaphore.availablePermits());
    }
}

