/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.internal.jdbc.IsSameRMOverrideXAResource;
import com.arjuna.ats.internal.jdbc.TransactionalDriverXAConnection;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public abstract class BaseTransactionalDriverXAConnection
implements ConnectionControl,
TransactionalDriverXAConnection {
    protected String _dbName;
    protected String _user;
    protected String _passwd;
    protected XAConnection _theConnection;
    protected XAResource _theXAResource;
    protected volatile Transaction _theTransaction;
    protected ConnectionModifier _theModifier;
    protected ConnectionImple _theArjunaConnection;
    protected XADataSource _theDataSource;

    protected void createConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"BaseTransactionalDriverXAConnection.createConnection");
        }
        try {
            if ((this._user == null || this._user.isEmpty()) && (this._passwd == null || this._passwd.isEmpty())) {
                if (jdbcLogger.logger.isTraceEnabled()) {
                    jdbcLogger.logger.trace((Object)"BaseTransactionalDriverXAConnection - getting connection with no user");
                }
                this._theConnection = this._theDataSource.getXAConnection();
            } else {
                if (jdbcLogger.logger.isTraceEnabled()) {
                    jdbcLogger.logger.trace((Object)("BaseTransactionalDriverXAConnection - getting connection for user " + this._user));
                }
                this._theConnection = this._theDataSource.getXAConnection(this._user, this._passwd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    public final void finalize() {
        try {
            if (this._theConnection != null) {
                this._theConnection.close();
                this._theConnection = null;
            }
            this._theXAResource = null;
        }
        catch (SQLException e) {
            jdbcLogger.i18NLogger.warn_drcdest(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setTransaction(Transaction tx2) {
        if (tx2 == null) {
            this._theTransaction = null;
            return true;
        }
        BaseTransactionalDriverXAConnection baseTransactionalDriverXAConnection = this;
        synchronized (baseTransactionalDriverXAConnection) {
            if (this._theTransaction == null) {
                this._theTransaction = tx2;
                return true;
            }
        }
        return this.validTransaction(tx2);
    }

    @Override
    public final boolean validTransaction(Transaction tx2) {
        boolean valid = true;
        if (this._theTransaction != null) {
            valid = this._theTransaction.equals(tx2);
        }
        return valid;
    }

    @Override
    public final XAResource getResource() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"BaseTransactionalDriverXAConnection.getResource ()");
        }
        try {
            if (this._theXAResource == null) {
                this._theXAResource = this._theModifier != null && this._theModifier.requiresSameRMOverride() ? new IsSameRMOverrideXAResource(this.getConnection().getXAResource()) : this.getConnection().getXAResource();
            }
            return this._theXAResource;
        }
        catch (Exception e) {
            e.printStackTrace();
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    public final void close() {
        this.reset();
    }

    public final void reset() {
        this._theXAResource = null;
        this._theTransaction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void closeCloseCurrentConnection() throws SQLException {
        BaseTransactionalDriverXAConnection baseTransactionalDriverXAConnection = this;
        synchronized (baseTransactionalDriverXAConnection) {
            if (this._theConnection != null) {
                this._theConnection.close();
                this._theConnection = null;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XAConnection getConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"BaseTransactionalDriverXAConnection.getConnection ()");
        }
        try {
            BaseTransactionalDriverXAConnection baseTransactionalDriverXAConnection = this;
            synchronized (baseTransactionalDriverXAConnection) {
                if (this._theConnection == null) {
                    this.createConnection();
                }
            }
            return this._theConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    @Override
    public final boolean inuse() {
        return this._theXAResource != null;
    }

    @Override
    public final String user() {
        return this._user;
    }

    @Override
    public final String password() {
        return this._passwd;
    }

    @Override
    public final String url() {
        return this._dbName;
    }

    @Override
    public final String dynamicClass() {
        return "";
    }

    @Override
    public final String dataSourceName() {
        return this._dbName;
    }

    @Override
    public final Transaction transaction() {
        return this._theTransaction;
    }

    @Override
    public final void setModifier(ConnectionModifier cm) {
        this._theModifier = cm;
        if (this._theModifier != null) {
            this._dbName = this._theModifier.initialise(this._dbName);
        }
    }

    @Override
    public final XADataSource xaDataSource() {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"BaseTransactionalDriverXAConnection.getDataSource ()");
        }
        return this._theDataSource;
    }

    public XADataSource getDataSource() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"DirectRecoverableConnection.getDataSource ()");
        }
        return this._theDataSource;
    }
}

