/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jboss.as.cli.scriptsupport.CLI;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportService;
import org.jboss.as.jdr.logger.JdrLogger;
import org.jboss.dmr.ModelNode;

public class CommandLineMain {
    private static final CommandLineParser parser = new GnuParser();
    private static final Options options = new Options();
    private static final HelpFormatter formatter = new HelpFormatter();
    private static final String usage = "jdr.{sh,bat,ps1} [options]";
    private static final String NEW_LINE = String.format("%n", new Object[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int port = 9990;
        String host = "localhost";
        String protocol = "remote+http";
        String config = null;
        try {
            CommandLine line = parser.parse(options, args, false);
            if (line.hasOption("help")) {
                formatter.printHelp(usage, NEW_LINE + JdrLogger.ROOT_LOGGER.jdrDescriptionMessage(), options, null);
                return;
            }
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            if (line.hasOption("port")) {
                port = Integer.parseInt(line.getOptionValue("port"));
            }
            if (line.hasOption("protocol")) {
                protocol = line.getOptionValue("protocol");
            }
            if (line.hasOption("config")) {
                config = line.getOptionValue("config");
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp(usage, options);
            return;
        }
        catch (NumberFormatException nfe) {
            System.out.println(nfe.getMessage());
            formatter.printHelp(usage, options);
            return;
        }
        System.out.println("Initializing JBoss Diagnostic Reporter...");
        CLI cli = CLI.newInstance();
        boolean embedded = false;
        JdrReport report = null;
        try {
            System.out.println(String.format("Trying to connect to %s %s:%s", protocol, host, port));
            cli.connect(protocol, host, port, null, null);
        }
        catch (IllegalStateException ex) {
            System.out.println("Starting embedded server");
            String startEmbeddedServer = "embed-server --std-out=echo " + (config != null && !config.isEmpty() ? " --server-config=" + config : "");
            cli.getCommandContext().handleSafe(startEmbeddedServer);
            embedded = true;
        }
        try {
            CLI.Result cmdResult = cli.cmd("/subsystem=jdr:generate-jdr-report()");
            ModelNode response = cmdResult.getResponse();
            if (Operations.isSuccessfulOutcome((ModelNode)response) || !embedded) {
                CommandLineMain.reportFailure(response);
                ModelNode result = response.get("result");
                report = new JdrReport(result);
            } else {
                report = CommandLineMain.standaloneCollect(cli, protocol, host, port);
            }
        }
        catch (IllegalStateException ise) {
            System.out.println(ise.getMessage());
            report = CommandLineMain.standaloneCollect(cli, protocol, host, port);
        }
        finally {
            if (cli != null) {
                try {
                    if (embedded) {
                        cli.getCommandContext().handleSafe("stop-embedded-server");
                    } else {
                        cli.disconnect();
                    }
                }
                catch (Exception e) {
                    System.out.println("Caught exception while disconnecting: " + e.getMessage());
                }
            }
        }
        CommandLineMain.printJdrReportInfo(report);
        System.exit(0);
    }

    private static void printJdrReportInfo(JdrReport report) {
        if (report != null) {
            System.out.println("JDR started: " + report.getFormattedStartTime());
            System.out.println("JDR ended: " + report.getFormattedEndTime());
            System.out.println("JDR location: " + report.getLocation());
            System.out.flush();
        }
    }

    private static JdrReport standaloneCollect(CLI cli, String protocol, String host, int port) {
        JdrReportService reportService = new JdrReportService();
        JdrReport report = null;
        try {
            report = reportService.standaloneCollect(cli, protocol, host, port);
        }
        catch (OperationFailedException e) {
            System.out.println("Failed to complete the JDR report: " + e.getMessage());
        }
        return report;
    }

    private static void reportFailure(ModelNode node) {
        if (!node.get("outcome").asString().equals("success")) {
            String msg = node.hasDefined("failure-description") ? (node.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", node.get("operation"), node.get("address"), node.get("failure-description")) : String.format("Operation failed: %s", node.get("failure-description"))) : String.format("Operation failed: %s", node);
            throw new RuntimeException(msg);
        }
    }

    static {
        options.addOption("h", "help", false, JdrLogger.ROOT_LOGGER.jdrHelpMessage());
        options.addOption("H", "host", true, JdrLogger.ROOT_LOGGER.jdrHostnameMessage());
        options.addOption("p", "port", true, JdrLogger.ROOT_LOGGER.jdrPortMessage());
        options.addOption("s", "protocol", true, JdrLogger.ROOT_LOGGER.jdrProtocolMessage());
        options.addOption("c", "config", true, JdrLogger.ROOT_LOGGER.jdrConfigMessage());
    }
}

