/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class ModClusterNodeResource
implements Resource.ResourceEntry {
    private final String name;
    private final String balancerName;
    private final String modClusterName;
    private ModelNode model = new ModelNode();

    public ModClusterNodeResource(String name, String balancerName, String modClusterName) {
        this.name = name;
        this.balancerName = balancerName;
        this.modClusterName = modClusterName;
    }

    public ModelNode getModel() {
        return this.model;
    }

    public void writeModel(ModelNode newModel) {
        this.model = newModel;
    }

    public boolean isModelDefined() {
        return true;
    }

    public boolean hasChild(PathElement element) {
        if ("context".equals(element.getKey())) {
            return this.getChildrenNames("context").contains(element.getValue());
        }
        return false;
    }

    public Resource getChild(PathElement element) {
        if ("context".equals(element.getKey())) {
            if (this.getChildrenNames("context").contains(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            return null;
        }
        return null;
    }

    public Resource requireChild(PathElement element) {
        if ("context".equals(element.getKey())) {
            if (this.getChildrenNames("context").contains(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            throw new Resource.NoSuchResourceException(element);
        }
        throw new Resource.NoSuchResourceException(element);
    }

    public boolean hasChildren(String childType) {
        if ("context".equals(childType)) {
            return !this.getChildrenNames("context").isEmpty();
        }
        return false;
    }

    public Resource navigate(PathAddress address) {
        if (address.size() == 1 && "context".equals(address.getElement(0).getKey())) {
            return this.requireChild(address.getElement(0));
        }
        throw new Resource.NoSuchResourceException(address.getElement(0));
    }

    public Set<String> getChildTypes() {
        return Collections.singleton("context");
    }

    public Set<String> getChildrenNames(String childType) {
        if ("context".equals(childType)) {
            ModClusterService service = ModClusterResource.service(this.modClusterName);
            if (service == null) {
                return Collections.emptySet();
            }
            ModCluster modCluster = service.getModCluster();
            ModClusterStatus status = modCluster.getController().getStatus();
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            ModClusterStatus.LoadBalancer balancer = status.getLoadBalancer(this.balancerName);
            ModClusterStatus.Node node = balancer.getNode(this.name);
            for (ModClusterStatus.Context context : node.getContexts()) {
                result.add(context.getName());
            }
            return result;
        }
        return null;
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("context".equals(childType)) {
            Set<String> names = this.getChildrenNames(childType);
            LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>(names.size());
            for (String name : names) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry(PathElement.pathElement((String)"context", (String)name)));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        throw UndertowLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        String type = address.getKey();
        throw UndertowLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        throw UndertowLogger.ROOT_LOGGER.cannotRemoveResourceOfType(type);
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean isProxy() {
        return false;
    }

    public Set<String> getOrderedChildTypes() {
        return Collections.emptySet();
    }

    public Resource clone() {
        return new ModClusterNodeResource(this.name, this.balancerName, this.modClusterName);
    }

    public String getName() {
        return this.name;
    }

    public PathElement getPathElement() {
        return PathElement.pathElement((String)"node", (String)this.name);
    }
}

