/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public final class HandlerService
implements Service<HttpHandler> {
    private final Consumer<HttpHandler> httpHandlerConsumer;
    private final Supplier<RequestController> requestController;
    private final HttpHandler httpHandler;
    private volatile ControlPoint controlPoint;
    private volatile HttpHandler realHandler;
    private final String name;

    HandlerService(Consumer<HttpHandler> httpHandlerConsumer, Supplier<RequestController> requestController, HttpHandler httpHandler, String name) {
        this.httpHandlerConsumer = httpHandlerConsumer;
        this.requestController = requestController;
        this.httpHandler = httpHandler;
        this.name = name;
    }

    public void start(StartContext context) {
        UndertowLogger.ROOT_LOGGER.tracef("starting handler: %s", this.httpHandler);
        if (this.requestController != null) {
            this.controlPoint = this.requestController.get().getControlPoint("org.wildfly.extension.undertow.handlers", this.name);
            this.realHandler = new GlobalRequestControllerHandler(this.httpHandler, this.controlPoint, Collections.emptyList());
        } else {
            this.realHandler = this.httpHandler;
        }
        this.httpHandlerConsumer.accept(this.realHandler);
    }

    public void stop(StopContext context) {
        this.httpHandlerConsumer.accept(null);
        if (this.controlPoint != null) {
            this.requestController.get().removeControlPoint(this.controlPoint);
            this.controlPoint = null;
        }
    }

    public HttpHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this.realHandler;
    }
}

