/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.RunnableWithException;

public class SynchronousExecutionContext
extends AbstractExecutionContext {
    protected final CountDownLatch syncLatch = new CountDownLatch(1);
    protected long timeout;
    protected TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    protected boolean wasSuspended;
    protected volatile boolean done;
    protected Object responseLock = new Object();
    protected ResteasyAsynchronousResponse asynchronousResponse;

    public SynchronousExecutionContext(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
        super(dispatcher, request, response);
    }

    public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
        return this.suspend(-1L);
    }

    public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
        return this.suspend(millis, TimeUnit.MILLISECONDS);
    }

    public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
        this.wasSuspended = true;
        this.asynchronousResponse = new SynchronousAsynchronousResponse(this.dispatcher, this.request, this.response);
        this.asynchronousResponse.setTimeout(time, unit);
        return this.asynchronousResponse;
    }

    public ResteasyAsynchronousResponse getAsyncResponse() {
        return this.asynchronousResponse;
    }

    public boolean isSuspended() {
        return this.wasSuspended;
    }

    public void complete() {
        if (this.wasSuspended) {
            this.asynchronousResponse.complete();
        }
    }

    public CompletionStage<Void> executeBlockingIo(RunnableWithException f, boolean hasInterceptors) {
        try {
            f.run();
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(e);
            return ret;
        }
    }

    public CompletionStage<Void> executeAsyncIo(CompletionStage<Void> f) {
        return f;
    }

    protected class SynchronousAsynchronousResponse
    extends AbstractAsynchronousResponse {
        protected boolean cancelled;

        public SynchronousAsynchronousResponse(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
            super(dispatcher, request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete() {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done) {
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                SynchronousExecutionContext.this.done = true;
                SynchronousExecutionContext.this.syncLatch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resume(Object entity) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                if (this.cancelled) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                return this.internalResume(entity, (Throwable t) -> SynchronousExecutionContext.this.syncLatch.countDown());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resume(Throwable exc) throws IllegalStateException {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                if (this.cancelled) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                return this.internalResume(exc, (Throwable t) -> SynchronousExecutionContext.this.syncLatch.countDown());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialRequestThreadFinished() {
            if (!SynchronousExecutionContext.this.wasSuspended) {
                return;
            }
            boolean result = false;
            try {
                if (SynchronousExecutionContext.this.timeout <= 0L) {
                    SynchronousExecutionContext.this.syncLatch.await();
                    result = true;
                } else {
                    result = SynchronousExecutionContext.this.syncLatch.await(SynchronousExecutionContext.this.timeout, SynchronousExecutionContext.this.timeoutUnit);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!result) {
                Object object = SynchronousExecutionContext.this.responseLock;
                synchronized (object) {
                    if (!SynchronousExecutionContext.this.done) {
                        if (this.timeoutHandler != null) {
                            this.timeoutHandler.handleTimeout((AsyncResponse)this);
                        }
                        if (!SynchronousExecutionContext.this.done) {
                            SynchronousExecutionContext.this.done = true;
                            this.internalResume(Response.status((int)503).build(), (Throwable t) -> {});
                        }
                    }
                }
            }
        }

        public boolean setTimeout(long time, TimeUnit unit) throws IllegalStateException {
            SynchronousExecutionContext.this.timeout = time;
            SynchronousExecutionContext.this.timeoutUnit = unit;
            return !SynchronousExecutionContext.this.done && !this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build(), (Throwable t) -> SynchronousExecutionContext.this.syncLatch.countDown());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(int retryAfter) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), (Throwable t) -> SynchronousExecutionContext.this.syncLatch.countDown());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(Date retryAfter) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (SynchronousExecutionContext.this.done) {
                    return false;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), (Throwable t) -> SynchronousExecutionContext.this.syncLatch.countDown());
        }

        public boolean isSuspended() {
            return !SynchronousExecutionContext.this.done;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean isDone() {
            return SynchronousExecutionContext.this.done;
        }
    }
}

