/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MessageIterator;

public class MessageBatch
implements Iterable<Message> {
    protected Address dest;
    protected Address sender;
    protected AsciiString cluster_name;
    protected Message[] messages;
    protected int index;
    protected boolean multicast;
    protected Mode mode = Mode.REG;
    protected static final int INCR = 5;
    protected static final ToIntBiFunction<Message, MessageBatch> length_visitor = (msg, batch) -> msg != null ? msg.getLength() : 0;
    protected static final ToLongBiFunction<Message, MessageBatch> total_size_visitor = (msg, batch) -> msg != null ? msg.size() : 0L;

    public MessageBatch(int capacity) {
        this.messages = new Message[capacity];
    }

    public MessageBatch(Collection<Message> msgs) {
        this.messages = new Message[msgs.size()];
        for (Message msg : msgs) {
            this.messages[this.index++] = msg;
        }
        this.mode = this.determineMode();
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Collection<Message> msgs) {
        this(dest, sender, cluster_name, multicast, msgs, null);
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Collection<Message> msgs, Predicate<Message> filter) {
        this.messages = new Message[msgs.size()];
        for (Message msg : msgs) {
            if (filter != null && !filter.test(msg)) continue;
            this.messages[this.index++] = msg;
        }
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.mode = this.determineMode();
    }

    public MessageBatch(Address dest, Address sender, AsciiString cluster_name, boolean multicast, Mode mode, int capacity) {
        this(capacity);
        this.dest = dest;
        this.sender = sender;
        this.cluster_name = cluster_name;
        this.multicast = multicast;
        this.mode = mode;
    }

    public Address getDest() {
        return this.dest;
    }

    public Address dest() {
        return this.dest;
    }

    public MessageBatch setDest(Address dest) {
        this.dest = dest;
        return this;
    }

    public MessageBatch dest(Address dest) {
        this.dest = dest;
        return this;
    }

    public Address getSender() {
        return this.sender;
    }

    public Address sender() {
        return this.sender;
    }

    public MessageBatch setSender(Address sender) {
        this.sender = sender;
        return this;
    }

    public MessageBatch sender(Address sender) {
        this.sender = sender;
        return this;
    }

    public AsciiString getClusterName() {
        return this.cluster_name;
    }

    public AsciiString clusterName() {
        return this.cluster_name;
    }

    public MessageBatch setClusterName(AsciiString name) {
        this.cluster_name = name;
        return this;
    }

    public MessageBatch clusterName(AsciiString name) {
        this.cluster_name = name;
        return this;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public boolean multicast() {
        return this.multicast;
    }

    public MessageBatch multicast(boolean flag) {
        this.multicast = flag;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Mode mode() {
        return this.mode;
    }

    public MessageBatch setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public MessageBatch mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public int getCapacity() {
        return this.messages.length;
    }

    public int capacity() {
        return this.messages.length;
    }

    public int index() {
        return this.index;
    }

    public Message[] array() {
        return this.messages;
    }

    public Message first() {
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            return this.messages[i];
        }
        return null;
    }

    public Message last() {
        for (int i = this.index - 1; i >= 0; --i) {
            if (this.messages[i] == null) continue;
            return this.messages[i];
        }
        return null;
    }

    public MessageBatch add(Message msg) {
        this.add(msg, true);
        return this;
    }

    public int add(Message msg, boolean resize) {
        if (msg == null) {
            return 0;
        }
        if (this.index >= this.messages.length) {
            if (!resize) {
                return 0;
            }
            this.resize();
        }
        this.messages[this.index++] = msg;
        return 1;
    }

    public MessageBatch add(MessageBatch batch) {
        this.add(batch, true);
        return this;
    }

    public int add(MessageBatch batch, boolean resize) {
        if (batch == null) {
            return 0;
        }
        if (this == batch) {
            throw new IllegalArgumentException("cannot add batch to itself");
        }
        int batch_size = batch.size();
        if (this.index + batch_size >= this.messages.length && resize) {
            this.resize(this.messages.length + batch_size + 1);
        }
        int cnt = 0;
        for (Message msg : batch) {
            if (this.index >= this.messages.length) {
                return cnt;
            }
            this.messages[this.index++] = msg;
            ++cnt;
        }
        return cnt;
    }

    public MessageBatch replace(Message existing_msg, Message new_msg) {
        if (existing_msg == null) {
            return this;
        }
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null || this.messages[i] != existing_msg) continue;
            this.messages[i] = new_msg;
            break;
        }
        return this;
    }

    public MessageBatch replace(Predicate<Message> filter, Message replacement, boolean match_all) {
        this.replaceIf(filter, replacement, match_all);
        return this;
    }

    public int replaceIf(Predicate<Message> filter, Message replacement, boolean match_all) {
        if (filter == null) {
            return 0;
        }
        int matched = 0;
        for (int i = 0; i < this.index; ++i) {
            if (!filter.test(this.messages[i])) continue;
            this.messages[i] = replacement;
            ++matched;
            if (!match_all) break;
        }
        return matched;
    }

    public int transferFrom(MessageBatch other, boolean clear) {
        if (other == null || this == other) {
            return 0;
        }
        int capacity = this.messages.length;
        int other_size = other.size();
        if (other_size == 0) {
            return 0;
        }
        if (capacity < other_size) {
            this.messages = new Message[other_size];
        }
        System.arraycopy(other.messages, 0, this.messages, 0, other_size);
        if (this.index > other_size) {
            for (int i = other_size; i < this.index; ++i) {
                this.messages[i] = null;
            }
        }
        this.index = other_size;
        if (clear) {
            other.clear();
        }
        return other_size;
    }

    public MessageBatch remove(Message msg) {
        return this.replace(msg, null);
    }

    public MessageBatch remove(Predicate<Message> filter) {
        return this.replace(filter, null, true);
    }

    public MessageBatch clear() {
        for (int i = 0; i < this.index; ++i) {
            this.messages[i] = null;
        }
        this.index = 0;
        return this;
    }

    public MessageBatch reset() {
        this.index = 0;
        return this;
    }

    public Collection<Message> getMatchingMessages(short id, boolean remove) {
        return this.map((msg, batch) -> {
            if (msg != null && msg.getHeader(id) != null) {
                if (remove) {
                    batch.remove((Message)msg);
                }
                return msg;
            }
            return null;
        });
    }

    public <T> Collection<T> map(BiFunction<Message, MessageBatch, T> visitor) {
        ArrayList<T> retval = null;
        for (int i = 0; i < this.index; ++i) {
            try {
                T result = visitor.apply(this.messages[i], this);
                if (result == null) continue;
                if (retval == null) {
                    retval = new ArrayList<T>();
                }
                retval.add(result);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retval;
    }

    public void forEach(BiConsumer<Message, MessageBatch> consumer) {
        for (int i = 0; i < this.index; ++i) {
            try {
                consumer.accept(this.messages[i], this);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int size() {
        int retval = 0;
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            ++retval;
        }
        return retval;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            return false;
        }
        return true;
    }

    public Mode determineMode() {
        int num_oob = 0;
        int num_reg = 0;
        int num_internal = 0;
        for (int i = 0; i < this.index; ++i) {
            if (this.messages[i] == null) continue;
            if (this.messages[i].isFlagSet(Message.Flag.OOB)) {
                ++num_oob;
                continue;
            }
            if (this.messages[i].isFlagSet(Message.Flag.INTERNAL)) {
                ++num_internal;
                continue;
            }
            ++num_reg;
        }
        if (num_internal > 0 && num_oob == 0 && num_reg == 0) {
            return Mode.INTERNAL;
        }
        if (num_oob > 0 && num_internal == 0 && num_reg == 0) {
            return Mode.OOB;
        }
        if (num_reg > 0 && num_oob == 0 && num_internal == 0) {
            return Mode.REG;
        }
        return Mode.MIXED;
    }

    public long totalSize() {
        long retval = 0L;
        for (int i = 0; i < this.index; ++i) {
            retval += total_size_visitor.applyAsLong(this.messages[i], this);
        }
        return retval;
    }

    public int length() {
        int retval = 0;
        for (int i = 0; i < this.index; ++i) {
            retval += length_visitor.applyAsInt(this.messages[i], this);
        }
        return retval;
    }

    public MessageIterator iterator() {
        return new BatchIterator(this.index);
    }

    public Stream<Message> stream() {
        Spliterator<Message> sp = Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
        return StreamSupport.stream(sp, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        sb.append(", mode=" + (Object)((Object)this.mode));
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(this.size() + " messages [capacity=" + this.messages.length + "]");
        return sb.toString();
    }

    public String printHeaders() {
        StringBuilder sb = new StringBuilder().append("dest=" + this.dest);
        if (this.sender != null) {
            sb.append(", sender=").append(this.sender);
        }
        sb.append("\n").append(this.size()).append(":\n");
        int count = 1;
        for (Message msg : this) {
            sb.append("#").append(count++).append(": ").append(msg.printHeaders()).append("\n");
        }
        return sb.toString();
    }

    protected void resize() {
        this.resize(this.messages.length + 5);
    }

    protected void resize(int new_capacity) {
        if (new_capacity <= this.messages.length) {
            return;
        }
        Message[] tmp = new Message[new_capacity];
        System.arraycopy(this.messages, 0, tmp, 0, this.messages.length);
        this.messages = tmp;
    }

    protected class BatchIterator
    implements MessageIterator {
        protected int current_index = -1;
        protected final int saved_index;

        public BatchIterator(int saved_index) {
            this.saved_index = saved_index;
        }

        @Override
        public boolean hasNext() {
            while (this.current_index + 1 < this.saved_index && MessageBatch.this.messages[this.current_index + 1] == null) {
                ++this.current_index;
            }
            return this.current_index + 1 < this.saved_index;
        }

        @Override
        public Message next() {
            if (this.current_index + 1 >= MessageBatch.this.messages.length) {
                throw new NoSuchElementException();
            }
            return MessageBatch.this.messages[++this.current_index];
        }

        @Override
        public void remove() {
            this.replace(null);
        }

        @Override
        public void replace(Message msg) {
            if (this.current_index >= 0) {
                MessageBatch.this.messages[this.current_index] = msg;
            }
        }
    }

    public static enum Mode {
        OOB,
        REG,
        INTERNAL,
        MIXED;

    }
}

