/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi;

import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.jaspi.ElytronAuthConfigFactory;
import org.wildfly.security.auth.server.SecurityDomain;

public class DelegatingAuthConfigFactory
extends AuthConfigFactory {
    private final ElytronAuthConfigFactory elytronAuthConfigFactory;
    private final AuthConfigFactory backupAuthConfigFactory;
    private final Supplier<Boolean> delegationAllowed;

    public DelegatingAuthConfigFactory(ElytronAuthConfigFactory elytronAuthConfigFactory, AuthConfigFactory backupAuthConfigFactory, Supplier<Boolean> delegationAllowed) {
        this.elytronAuthConfigFactory = Assert.checkNotNullParam("elytronAuthConfigFactory", elytronAuthConfigFactory);
        this.backupAuthConfigFactory = Assert.checkNotNullParam("backupAuthConfigFactory", backupAuthConfigFactory);
        this.delegationAllowed = delegationAllowed;
    }

    public DelegatingAuthConfigFactory(ElytronAuthConfigFactory elytronAuthConfigFactory, AuthConfigFactory backupAuthConfigFactory) {
        this(elytronAuthConfigFactory, backupAuthConfigFactory, () -> SecurityDomain.getCurrent() == null);
    }

    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        AuthConfigProvider authConfigProvider = this.elytronAuthConfigFactory.getConfigProvider(layer, appContext, listener);
        if (authConfigProvider != null || this.elytronAuthConfigFactory.matchesRegistration(layer, appContext) || !this.delegationAllowed.get().booleanValue()) {
            return authConfigProvider;
        }
        return this.backupAuthConfigFactory.getConfigProvider(layer, appContext, listener);
    }

    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        String[] elytronRegistrationIds = this.elytronAuthConfigFactory.getRegistrationIDs(provider);
        String[] backupRegistrationIds = this.backupAuthConfigFactory.getRegistrationIDs(provider);
        return DelegatingAuthConfigFactory.combine(elytronRegistrationIds, backupRegistrationIds);
    }

    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        String[] elytronRegistrationIds = this.elytronAuthConfigFactory.detachListener(listener, layer, appContext);
        String[] backupRegistrationIds = this.backupAuthConfigFactory.detachListener(listener, layer, appContext);
        return DelegatingAuthConfigFactory.combine(elytronRegistrationIds, backupRegistrationIds);
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        AuthConfigFactory.RegistrationContext registrationContext = this.elytronAuthConfigFactory.getRegistrationContext(registrationID);
        if (registrationContext == null) {
            registrationContext = this.backupAuthConfigFactory.getRegistrationContext(registrationID);
        }
        return registrationContext;
    }

    public void refresh() {
        this.elytronAuthConfigFactory.refresh();
        this.backupAuthConfigFactory.refresh();
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        return this.elytronAuthConfigFactory.registerConfigProvider(className, properties, layer, appContext, description);
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        return this.elytronAuthConfigFactory.registerConfigProvider(provider, layer, appContext, description);
    }

    public boolean removeRegistration(String registrationID) {
        return this.elytronAuthConfigFactory.removeRegistration(registrationID) || this.backupAuthConfigFactory.removeRegistration(registrationID);
    }

    private static String[] combine(String[] left, String[] right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        String[] result = new String[left.length + right.length];
        if (left.length > 0) {
            System.arraycopy(left, 0, result, 0, left.length);
        }
        if (right.length > 0) {
            System.arraycopy(right, 0, result, left.length, right.length);
        }
        return result;
    }
}

