/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.principal;

import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.List;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;

public final class X509SubjectAltNameEvidenceDecoder
implements EvidenceDecoder {
    private final int altNametype;
    private final int segment;

    public X509SubjectAltNameEvidenceDecoder(int altNameType) {
        this(altNameType, 0);
    }

    public X509SubjectAltNameEvidenceDecoder(int altNameType, int segment) {
        this.altNametype = altNameType;
        this.segment = segment;
    }

    @Override
    public Principal getPrincipal(Evidence evidence) {
        if (!(evidence instanceof X509PeerCertificateChainEvidence)) {
            return null;
        }
        try {
            Collection<List<?>> subjectAltNames = ((X509PeerCertificateChainEvidence)evidence).getFirstCertificate().getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                int typeOccurrence = 0;
                for (List<?> subjectAltName : subjectAltNames) {
                    int type = (Integer)subjectAltName.get(0);
                    if (type != this.altNametype) continue;
                    if (typeOccurrence == this.segment) {
                        return new NamePrincipal((String)subjectAltName.get(1));
                    }
                    ++typeOccurrence;
                }
            }
            return null;
        }
        catch (CertificateParsingException e) {
            return null;
        }
    }
}

