/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.jboss;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.clustering.infinispan.marshalling.ByteBufferExternalizer;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.DefaultExternalizerProviders;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum JBossMarshallingVersion implements Function<Map.Entry<ClassResolver, ClassLoader>, MarshallingConfiguration>
{
    VERSION_1{

        @Override
        public MarshallingConfiguration apply(Map.Entry<ClassResolver, ClassLoader> entry) {
            MarshallingConfiguration config = new MarshallingConfiguration();
            ClassLoader loader = entry.getValue();
            config.setClassResolver(entry.getKey());
            config.setClassTable((ClassTable)new DynamicClassTable(new ClassLoader[]{loader}));
            config.setObjectTable((ObjectTable)new ExternalizerObjectTable(1.loadExternalizers(loader)));
            return config;
        }
    };

    public static final JBossMarshallingVersion CURRENT;

    static List<Externalizer<Object>> loadExternalizers(final ClassLoader loader) {
        List loadedExternalizers = (List)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<List<Externalizer<Object>>>(){

            @Override
            public List<Externalizer<Object>> run() {
                LinkedList<Externalizer<Object>> externalizers = new LinkedList<Externalizer<Object>>();
                for (Externalizer externalizer : ServiceLoader.load(Externalizer.class, loader)) {
                    externalizers.add((Externalizer<Object>)externalizer);
                }
                return externalizers;
            }
        });
        EnumSet<DefaultExternalizerProviders> providers = EnumSet.allOf(DefaultExternalizerProviders.class);
        int size = loadedExternalizers.size() + 1;
        for (DefaultExternalizerProviders provider : providers) {
            size += provider.get().size();
        }
        ArrayList<Externalizer<Object>> result = new ArrayList<Externalizer<Object>>(size);
        result.add(ByteBufferExternalizer.INSTANCE);
        for (DefaultExternalizerProviders provider : providers) {
            result.addAll(provider.get());
        }
        result.addAll(loadedExternalizers);
        return result;
    }

    static {
        CURRENT = VERSION_1;
    }
}

