/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.marshalling.InfinispanMarshallerFactory;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class GlobalConfigurationServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<GlobalConfiguration> {
    private final SupplierDependency<ModuleLoader> loader;
    private final SupplierDependency<List<Module>> modules;
    private final SupplierDependency<TransportConfiguration> transport;
    private final Map<ThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>> pools = new EnumMap<ThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>>(ThreadPoolResourceDefinition.class);
    private final Map<ScheduledThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>> scheduledPools = new EnumMap<ScheduledThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>>(ScheduledThreadPoolResourceDefinition.class);
    private final String name;
    private volatile SupplierDependency<MBeanServer> server;
    private volatile String defaultCache;
    private volatile boolean statisticsEnabled;
    private volatile InfinispanMarshallerFactory marshallerFactory;

    GlobalConfigurationServiceConfigurator(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.CONFIGURATION, address);
        this.name = address.getLastElement().getValue();
        this.loader = new ServiceSupplierDependency(Services.JBOSS_SERVICE_MODULE_LOADER);
        this.modules = new ServiceSupplierDependency(CacheContainerComponent.MODULES.getServiceName(address));
        this.transport = new ServiceSupplierDependency(CacheContainerComponent.TRANSPORT.getServiceName(address));
        for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.of(ThreadPoolResourceDefinition.LISTENER, ThreadPoolResourceDefinition.BLOCKING, ThreadPoolResourceDefinition.NON_BLOCKING)) {
            this.pools.put(threadPoolResourceDefinition, (SupplierDependency<ThreadPoolConfiguration>)new ServiceSupplierDependency(threadPoolResourceDefinition.getServiceName(address)));
        }
        for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
            this.scheduledPools.put(scheduledThreadPoolResourceDefinition, (SupplierDependency<ThreadPoolConfiguration>)new ServiceSupplierDependency(scheduledThreadPoolResourceDefinition.getServiceName(address)));
        }
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.server = context.hasOptionalCapability(CommonRequirement.MBEAN_SERVER.getName(), null, null) ? new ServiceSupplierDependency(CommonRequirement.MBEAN_SERVER.getServiceName(context)) : null;
        this.defaultCache = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.statisticsEnabled = CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.marshallerFactory = InfinispanMarshallerFactory.valueOf((String)CacheContainerResourceDefinition.Attribute.MARSHALLER.resolveModelAttribute((ExpressionResolver)context, model).asString());
        return this;
    }

    @Override
    public GlobalConfiguration get() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.cacheManagerName(this.name).defaultCacheName(this.defaultCache).cacheContainer().statistics(this.statisticsEnabled);
        builder.transport().read((TransportConfiguration)this.transport.get());
        List modules = (List)this.modules.get();
        Marshaller marshaller = (Marshaller)this.marshallerFactory.apply(this.loader.get(), (Object)modules);
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache-container will use %s", this.name, marshaller.getClass().getName());
        builder.serialization().marshaller(marshaller).addContextInitializer(new SerializationContextInitializer(){

            @Deprecated
            public String getProtoFile() throws UncheckedIOException {
                return null;
            }

            @Deprecated
            public String getProtoFileName() {
                return null;
            }

            public void registerMarshallers(SerializationContext context) {
            }

            public void registerSchema(SerializationContext context) {
            }
        });
        builder.classLoader((ClassLoader)(modules.size() > 1 ? new AggregatedClassLoader((Collection)modules.stream().map(Module::getClassLoader).collect(Collectors.toList())) : ((Module)modules.get(0)).getClassLoader()));
        builder.blockingThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.BLOCKING).get());
        builder.listenerThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.LISTENER).get());
        builder.nonBlockingThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.NON_BLOCKING).get());
        builder.expirationThreadPool().read((ThreadPoolConfiguration)this.scheduledPools.get(ScheduledThreadPoolResourceDefinition.EXPIRATION).get());
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        builder.metrics().gauges(false).histograms(false);
        builder.jmx().domain("org.wildfly.clustering.infinispan").mBeanServerLookup((MBeanServerLookup)(this.server != null ? new MBeanServerProvider((MBeanServer)this.server.get()) : null)).enabled(this.server != null);
        if (modules.stream().map(Module::getName).noneMatch("org.infinispan.hibernate-cache"::equals)) {
            ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        }
        builder.globalState().configurationStorage(ConfigurationStorage.IMMUTABLE).disable();
        return builder.build();
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer global = new CompositeDependency(new Dependency[]{this.loader, this.modules, this.transport, this.server}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.pools.values()) {
            dependency.register(builder);
        }
        for (Dependency dependency : this.scheduledPools.values()) {
            dependency.register(builder);
        }
        FunctionalService service = new FunctionalService(global, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

