/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.json.JsonObject;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.x500.cert.acme.Acme;
import org.wildfly.security.x500.cert.acme.AcmeAccount;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.wildfly.security.x500.cert.acme.ElytronMessages;

public final class AcmeChallenge {
    private final Type type;
    private final String url;
    private final String token;
    private final String identifierType;
    private final String identifierValue;

    public AcmeChallenge(Type type, String url, String token, String identifierType, String identifierValue) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"url", (Object)url);
        Assert.checkNotNullParam((String)"token", (Object)token);
        Assert.checkNotNullParam((String)"identifierType", (Object)identifierType);
        Assert.checkNotNullParam((String)"identifierValue", (Object)identifierValue);
        this.type = type;
        this.url = url;
        this.token = token;
        this.identifierType = identifierType;
        this.identifierValue = identifierValue;
    }

    public Type getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public String getIdentifierValue() {
        return this.identifierValue;
    }

    public String getKeyAuthorization(AcmeAccount account) throws AcmeException {
        Assert.checkNotNullParam((String)"account", (Object)account);
        JsonObject jwk = Acme.getJwk(account.getPublicKey(), account.getAlgHeader());
        byte[] jwkWithoutWhitespace = CodePointIterator.ofString((String)jwk.toString()).skip(Character::isWhitespace).skipCrLf().asUtf8().drain();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(jwkWithoutWhitespace);
            byte[] jwkThumbprint = messageDigest.digest();
            return this.token + "." + Acme.base64UrlEncode(jwkThumbprint);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.acme.unableToDetermineKeyAuthorizationString(e);
        }
    }

    public static class UnknownType
    extends Type {
        UnknownType(String value) {
            super(value);
        }
    }

    public static class Type {
        public static final Type HTTP_01 = new Type("http-01");
        public static final Type DNS_01 = new Type("dns-01");
        public static final Type TLS_SNI_01 = new Type("tls-sni-01");
        public static final Type TLS_SNI_02 = new Type("tls-sni-02");
        public static final Type TLS_ALPN_01 = new Type("tls-alpn-01");
        private final String value;

        Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static Type forName(String name) {
            switch (name) {
                case "http-01": {
                    return HTTP_01;
                }
                case "dns-01": {
                    return DNS_01;
                }
                case "tls-sni-01": {
                    return TLS_SNI_01;
                }
                case "tls-sni-02": {
                    return TLS_SNI_02;
                }
                case "tls-alpn-01": {
                    return TLS_ALPN_01;
                }
            }
            return new UnknownType(name);
        }
    }
}

