/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet._private;

import java.security.Permission;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYBATCH")
public interface BatchLogger
extends BasicLogger {
    public static final BatchLogger LOGGER = (BatchLogger)Logger.getMessageLogger(BatchLogger.class, (String)"org.wildfly.extension.batch");

    @Message(id=1, value="Error processing META-INF/batch-jobs directory.")
    public DeploymentUnitProcessingException errorProcessingBatchJobsDir(@Cause Throwable var1);

    @Message(id=2, value="Resources of type %s cannot be removed")
    public UnsupportedOperationException cannotRemoveResourceOfType(String var1);

    @Message(id=3, value="Could not find deployment name: %s")
    public IllegalArgumentException couldNotFindDeploymentName(String var1);

    @Message(id=4, value="The service JobOperatorService has been stopped and cannot execute operations.")
    public IllegalStateException jobOperatorServiceStopped();

    @Message(id=5, value="The job name '%s' was not found for the deployment.")
    public NoSuchJobException noSuchJobException(String var1);

    @Message(id=6, value="Could not find the job XML file in the deployment: %s")
    public JobStartException couldNotFindJobXml(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Failed processing the job XML file %s. Attempting to execute this job may result in errors.")
    public void invalidJobXmlFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Empty job-repository element found in deployment descriptor. Using the default job repository for deployment %s.")
    public void emptyJobRepositoryElement(String var1);

    @Message(id=9, value="Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed")
    public IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement var1);

    @Message(id=11, value="Failed to create %s job repository.")
    public StartException failedToCreateJobRepository(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=13, value="Only one job repository can be defined in the jboss-all.xml deployment descriptor. The first job repository will be used.")
    public void multipleJobRepositoriesFound();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="Stopping execution %d of %s for deployment %s")
    public void stoppingJob(long var1, String var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15, value="Failed to stop execution %d for job %s on deployment %s")
    public void stoppingJobFailed(@Cause Throwable var1, long var2, String var4, String var5);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Failed to restart execution %d for job %s on deployment %s")
    public void failedRestartingJob(@Cause Throwable var1, long var2, String var4, String var5);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Restarting previously stopped batch job %s. Previous execution id %d. New execution id %d.")
    public void restartingJob(String var1, long var2, long var4);

    @Message(id=19, value="No batch environment was found for class loader: %s")
    public BatchRuntimeException noBatchEnvironmentFound(ClassLoader var1);

    @Message(id=20, value="Permission denied. User %s does not have %s permissions.")
    public JobSecurityException unauthorized(String var1, Permission var2);
}

