/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ComplexAttributes {
    static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING).setRequired(true)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition PROVIDER_ARGUMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-argument", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition[] KEY_STORE_FIELDS = new SimpleAttributeDefinition[]{PASSWORD, TYPE, URL, PROVIDER, PROVIDER_ARGUMENT};
    static final SimpleAttributeDefinition[] KEY_MANAGER_FIELDS = new SimpleAttributeDefinition[]{ALGORITHM, PROVIDER};

    ComplexAttributes() {
    }

    protected static final class KeyStoreAttributeValidator
    implements ParameterValidator {
        private final String name;

        public KeyStoreAttributeValidator(String name) {
            this.name = name;
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            ModelNode parameters;
            if (this.name.equals(parameterName) && this.isConfigured(parameters = value.clone())) {
                for (SimpleAttributeDefinition attribute : KEY_STORE_FIELDS) {
                    attribute.getValidator().validateParameter(attribute.getName(), parameters.get(attribute.getName()));
                }
            }
        }

        private boolean isConfigured(ModelNode keystore) {
            return keystore.hasDefined("type") || keystore.hasDefined("url") || keystore.hasDefined("provider") || keystore.hasDefined("provider-argument");
        }
    }

    protected static final class KeyManagerAttributeMarshaller
    extends DefaultAttributeMarshaller {
        protected KeyManagerAttributeMarshaller() {
        }

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (attribute.isMarshallable(resourceModel, marshallDefault)) {
                if ((resourceModel = resourceModel.get(attribute.getName())).hasDefined("algorithm")) {
                    writer.writeAttribute(attribute.getName() + "-factory-" + "algorithm", resourceModel.get("algorithm").asString());
                }
                if (resourceModel.hasDefined("provider")) {
                    writer.writeAttribute(attribute.getName() + "-factory-" + "provider", resourceModel.get("provider").asString());
                }
            }
        }
    }

    protected static final class KeyStoreAttributeMarshaller
    extends DefaultAttributeMarshaller {
        protected KeyStoreAttributeMarshaller() {
        }

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (attribute.isMarshallable(resourceModel, marshallDefault)) {
                if ((resourceModel = resourceModel.get(attribute.getName())).hasDefined("password")) {
                    writer.writeAttribute(attribute.getName() + "-" + "password", resourceModel.get("password").asString());
                }
                if (resourceModel.hasDefined("type")) {
                    writer.writeAttribute(attribute.getName() + "-" + "type", resourceModel.get("type").asString());
                }
                if (resourceModel.hasDefined("url")) {
                    writer.writeAttribute(attribute.getName() + "-" + "url", resourceModel.get("url").asString());
                }
                if (resourceModel.hasDefined("provider")) {
                    writer.writeAttribute(attribute.getName() + "-" + "provider", resourceModel.get("provider").asString());
                }
                if (resourceModel.hasDefined("provider-argument")) {
                    writer.writeAttribute(attribute.getName() + "-" + "provider-argument", resourceModel.get("provider-argument").asString());
                }
            }
        }
    }
}

