/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.TimeoutConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Timeout;

public final class TimeoutConfigImpl
implements TimeoutConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Timeout instance;
    private final boolean onMethod;
    private Long _value;
    private ChronoUnit _unit;

    private TimeoutConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.timeout;
        this.onMethod = method.annotationsPresentDirectly.contains(Timeout.class);
    }

    public static TimeoutConfigImpl create(FaultToleranceMethod method) {
        if (method.timeout == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(Timeout.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new TimeoutConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Timeout.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public long value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            this._value = this.onMethod ? (Long)config.getOptionalValue(this.getConfigKeyForMethod("value"), Long.TYPE).orElse(null) : (Long)config.getOptionalValue(this.getConfigKeyForClass("value"), Long.TYPE).orElse(null);
            if (this._value == null) {
                this._value = config.getOptionalValue("Timeout/value", Long.TYPE).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public ChronoUnit unit() {
        if (this._unit == null) {
            Config config = ConfigProvider.getConfig();
            this._unit = this.onMethod ? (ChronoUnit)config.getOptionalValue(this.getConfigKeyForMethod("unit"), ChronoUnit.class).orElse(null) : (ChronoUnit)config.getOptionalValue(this.getConfigKeyForClass("unit"), ChronoUnit.class).orElse(null);
            if (this._unit == null) {
                this._unit = config.getOptionalValue("Timeout/unit", ChronoUnit.class).orElse(null);
            }
            if (this._unit == null) {
                this._unit = this.instance.unit();
            }
        }
        return this._unit;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/Timeout/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/Timeout/" + key;
    }
}

