/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.targets;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetListener;

public abstract class AbstractTarget
implements Target {
    private final TransportConfiguration connector;
    private String nodeID;
    private String username;
    private String password;
    private int checkPeriod;
    private TargetListener listener;

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    protected void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    @Override
    public void setCheckPeriod(int checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    @Override
    public TargetListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(TargetListener listener) {
        this.listener = listener;
    }

    @Override
    public TransportConfiguration getConnector() {
        return this.connector;
    }

    public AbstractTarget(TransportConfiguration connector, String nodeID) {
        this.connector = connector;
        this.nodeID = nodeID;
    }

    protected void fireConnectedEvent() {
        if (this.listener != null) {
            this.listener.targetConnected();
        }
    }

    protected void fireDisconnectedEvent() {
        if (this.listener != null) {
            this.listener.targetDisconnected();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [connector=" + this.connector + ", nodeID=" + this.nodeID + "]";
    }
}

