/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.targets;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetListener;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetProbe;
import org.jboss.logging.Logger;

public class TargetMonitor
extends ActiveMQScheduledComponent
implements TargetListener {
    private static final Logger logger = Logger.getLogger(TargetMonitor.class);
    private final Target target;
    private final List<TargetProbe> targetProbes;
    private volatile boolean targetReady = false;

    public Target getTarget() {
        return this.target;
    }

    public boolean isTargetReady() {
        return this.targetReady;
    }

    public TargetMonitor(ScheduledExecutorService scheduledExecutorService, int checkPeriod, Target target, List<TargetProbe> targetProbes) {
        super(scheduledExecutorService, 0L, (long)checkPeriod, TimeUnit.MILLISECONDS, false);
        this.target = target;
        this.targetProbes = targetProbes;
    }

    public synchronized void start() {
        this.target.setListener(this);
        super.start();
    }

    public synchronized void stop() {
        super.stop();
        this.targetReady = false;
        this.target.setListener(null);
        try {
            this.target.disconnect();
        }
        catch (Exception e) {
            logger.debug((Object)("Error on disconnecting target " + this.target), (Throwable)e);
        }
    }

    public void run() {
        try {
            if (!this.target.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Connecting to " + this.target));
                }
                this.target.connect();
            }
            boolean bl = this.targetReady = this.target.checkReadiness() && this.checkTargetProbes();
            if (logger.isDebugEnabled()) {
                if (this.targetReady) {
                    logger.debug((Object)(this.target + " is ready"));
                } else {
                    logger.debug((Object)(this.target + " is not ready"));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error monitoring " + this.target), (Throwable)e);
            this.targetReady = false;
        }
    }

    private boolean checkTargetProbes() {
        for (TargetProbe targetProbe : this.targetProbes) {
            if (targetProbe.check(this.target)) continue;
            logger.info((Object)(targetProbe.getName() + " has failed on " + this.target));
            return false;
        }
        return true;
    }

    @Override
    public void targetConnected() {
    }

    @Override
    public void targetDisconnected() {
        this.targetReady = false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [target=" + this.target + ", targetReady=" + this.targetReady + "]";
    }
}

