/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.jboss.logging.Logger;

public class ClusterController
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(ClusterController.class);
    private final QuorumManager quorumManager;
    private final ActiveMQServer server;
    private final Map<SimpleString, ServerLocatorInternal> locators = new HashMap<SimpleString, ServerLocatorInternal>();
    private SimpleString defaultClusterConnectionName;
    private ServerLocator defaultLocator;
    private ServerLocator replicationLocator;
    private final Executor executor;
    private CountDownLatch replicationClusterConnectedLatch;
    private boolean started;
    private SimpleString replicatedClusterName;

    public ClusterController(ActiveMQServer server, ScheduledExecutorService scheduledExecutor, boolean useQuorumManager) {
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        this.quorumManager = useQuorumManager ? new QuorumManager(scheduledExecutor, this) : null;
    }

    public ClusterController(ActiveMQServer server, ScheduledExecutorService scheduledExecutor) {
        this(server, scheduledExecutor, true);
    }

    public void start() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting Cluster Controller " + System.identityHashCode(this) + " for server " + this.server));
        }
        if (this.started) {
            return;
        }
        this.defaultLocator = (ServerLocator)this.locators.get(this.defaultClusterConnectionName);
        if (this.replicatedClusterName != null && !this.replicatedClusterName.equals((Object)this.defaultClusterConnectionName)) {
            this.replicationLocator = (ServerLocator)this.locators.get(this.replicatedClusterName);
            if (this.replicationLocator == null) {
                ActiveMQServerLogger.LOGGER.noClusterConnectionForReplicationCluster();
                this.replicationLocator = this.defaultLocator;
            }
        } else {
            this.replicationLocator = this.defaultLocator;
        }
        this.replicationClusterConnectedLatch = new CountDownLatch(1);
        if (this.quorumManager != null) {
            if (this.defaultLocator != null) {
                this.defaultLocator.addClusterTopologyListener((ClusterTopologyListener)this.quorumManager);
            }
            this.quorumManager.start();
        }
        this.started = true;
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            if (!serverLocatorInternal.isConnectable()) continue;
            this.executor.execute(new ConnectRunnable(serverLocatorInternal));
        }
    }

    public void addClusterTopologyListener(ClusterTopologyListener clusterTopologyListener) {
        if (!this.started || this.defaultLocator == null) {
            throw new IllegalStateException("the controller must be started and with a locator initialized");
        }
        this.defaultLocator.addClusterTopologyListener(clusterTopologyListener);
    }

    public void removeClusterTopologyListener(ClusterTopologyListener clusterTopologyListener) {
        if (!this.started || this.defaultLocator == null) {
            throw new IllegalStateException("the controller must be started and with a locator initialized");
        }
        this.defaultLocator.removeClusterTopologyListener(clusterTopologyListener);
    }

    public void stop() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Stopping Cluster Controller " + System.identityHashCode(this) + " for server " + this.server));
        }
        this.started = false;
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            serverLocatorInternal.close();
        }
        if (this.quorumManager != null) {
            this.quorumManager.stop();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public QuorumManager getQuorumManager() {
        return this.quorumManager;
    }

    public void setDefaultClusterConnectionName(SimpleString defaultClusterConnection) {
        this.defaultClusterConnectionName = defaultClusterConnection;
    }

    public void addClusterConnection(SimpleString name, DiscoveryGroupConfiguration dg, ClusterConnectionConfiguration config, TransportConfiguration connector) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        this.configAndAdd(name, (ServerLocatorInternal)serverLocator, config, connector);
    }

    public void addClusterConnection(SimpleString name, TransportConfiguration[] tcConfigs, ClusterConnectionConfiguration config) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        this.configAndAdd(name, (ServerLocatorInternal)serverLocator, config, null);
    }

    private void configAndAdd(SimpleString name, ServerLocatorInternal serverLocator, ClusterConnectionConfiguration config, TransportConfiguration connector) {
        serverLocator.setConnectionTTL(config.getConnectionTTL());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setReconnectAttempts(config.getReconnectAttempts());
        serverLocator.setInitialConnectAttempts(config.getInitialConnectAttempts());
        serverLocator.setCallTimeout(config.getCallTimeout());
        serverLocator.setCallFailoverTimeout(config.getCallFailoverTimeout());
        serverLocator.setRetryInterval(config.getRetryInterval());
        serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        serverLocator.setMaxRetryInterval(config.getMaxRetryInterval());
        serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)serverLocator, this.server.getStorageManager()));
        serverLocator.setThreadPools(this.server.getThreadPool(), this.server.getScheduledPool());
        if (connector != null) {
            serverLocator.setClusterTransportConfiguration(connector);
        }
        try {
            serverLocator.initialize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.locators.put(name, serverLocator);
    }

    public void addClusterTopologyListenerForReplication(ClusterTopologyListener listener) {
        if (this.replicationLocator != null) {
            this.replicationLocator.addClusterTopologyListener(listener);
        }
    }

    public void removeClusterTopologyListenerForReplication(ClusterTopologyListener listener) {
        if (this.replicationLocator != null) {
            this.replicationLocator.removeClusterTopologyListener(listener);
        }
    }

    public void addIncomingInterceptorForReplication(Interceptor interceptor) {
        this.replicationLocator.addIncomingInterceptor(interceptor);
    }

    public void removeIncomingInterceptorForReplication(Interceptor interceptor) {
        this.replicationLocator.removeIncomingInterceptor(interceptor);
    }

    public ClusterControl connectToNode(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.defaultLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInReplicatedCluster(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.replicationLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInCluster(ClientSessionFactoryInternal sf) {
        sf.getServerLocator().setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance(sf.getServerLocator(), this.server.getStorageManager()));
        return new ClusterControl(sf, this.server);
    }

    public long getRetryIntervalForReplicatedCluster() {
        return this.replicationLocator.getRetryInterval();
    }

    public void awaitConnectionToReplicationCluster() throws InterruptedException {
        this.replicationClusterConnectedLatch.await();
    }

    public void addClusterChannelHandler(Channel channel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, Activation activation) {
        channel.setHandler((ChannelHandler)new ClusterControllerChannelHandler(channel, acceptorUsed, remotingConnection, activation.getActivationChannelHandler(channel, acceptorUsed)));
    }

    public int getDefaultClusterSize() {
        return this.defaultLocator.getTopology().getMembers().size();
    }

    public Topology getDefaultClusterTopology() {
        return this.defaultLocator.getTopology();
    }

    public SimpleString getNodeID() {
        return this.server.getNodeID();
    }

    public String getIdentity() {
        return this.server.getIdentity();
    }

    public void setReplicatedClusterName(String replicatedClusterName) {
        this.replicatedClusterName = new SimpleString(replicatedClusterName);
    }

    public Map<SimpleString, ServerLocatorInternal> getLocators() {
        return this.locators;
    }

    public ServerLocator getReplicationLocator() {
        return this.replicationLocator;
    }

    public ServerLocator getServerLocator(SimpleString name) {
        return (ServerLocator)this.locators.get(name);
    }

    private final class ConnectRunnable
    implements Runnable {
        private final ServerLocatorInternal serverLocator;

        private ConnectRunnable(ServerLocatorInternal serverLocator) {
            this.serverLocator = serverLocator;
        }

        @Override
        public void run() {
            try {
                if (ClusterController.this.started) {
                    this.serverLocator.connect();
                    if (this.serverLocator == ClusterController.this.replicationLocator) {
                        ClusterController.this.replicationClusterConnectedLatch.countDown();
                    }
                }
            }
            catch (ActiveMQException e) {
                if (!ClusterController.this.started) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retry on Cluster Controller " + System.identityHashCode(ClusterController.this) + " server = " + ClusterController.this.server));
                }
                ClusterController.this.server.getScheduledPool().schedule(this, this.serverLocator.getRetryInterval(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class ClusterControllerChannelHandler
    implements ChannelHandler {
        private final Channel clusterChannel;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection remotingConnection;
        private final ChannelHandler channelHandler;
        boolean authorized = false;

        private ClusterControllerChannelHandler(Channel clusterChannel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, ChannelHandler channelHandler) {
            this.clusterChannel = clusterChannel;
            this.acceptorUsed = acceptorUsed;
            this.remotingConnection = remotingConnection;
            this.channelHandler = channelHandler;
        }

        public void handlePacket(Packet packet) {
            if (!ClusterController.this.isStarted()) {
                if (this.channelHandler != null) {
                    this.channelHandler.handlePacket(packet);
                }
                return;
            }
            if (!this.authorized) {
                if (packet.getType() == 125) {
                    ClusterConnection clusterConnection = this.acceptorUsed.getClusterConnection();
                    if (clusterConnection == null) {
                        clusterConnection = ClusterController.this.server.getClusterManager().getDefaultConnection(null);
                    }
                    if (clusterConnection == null && ClusterController.this.server.getConfiguration().isSecurityEnabled()) {
                        ActiveMQServerLogger.LOGGER.failedToFindClusterConnection(packet.toString());
                        return;
                    }
                    ClusterConnectMessage msg = (ClusterConnectMessage)packet;
                    if (ClusterController.this.server.getConfiguration().isSecurityEnabled() && !clusterConnection.verify(msg.getClusterUser(), msg.getClusterPassword())) {
                        this.clusterChannel.send((Packet)new ClusterConnectReplyMessage(false));
                    } else {
                        this.authorized = true;
                        this.clusterChannel.send((Packet)new ClusterConnectReplyMessage(true));
                    }
                }
            } else if (packet.getType() == 111) {
                NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                Pair pair = msg.isBackup() ? new Pair(null, (Object)msg.getConnector()) : new Pair((Object)msg.getConnector(), (Object)msg.getBackupConnector());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Server " + ClusterController.this.server + " receiving nodeUp from NodeID=" + msg.getNodeID() + ", pair=" + pair));
                }
                if (this.acceptorUsed != null) {
                    ClusterConnection clusterConn = this.acceptorUsed.getClusterConnection();
                    if (clusterConn != null) {
                        String scaleDownGroupName = msg.getScaleDownGroupName();
                        clusterConn.nodeAnnounced(msg.getCurrentEventID(), msg.getNodeID(), msg.getBackupGroupName(), scaleDownGroupName, (Pair<TransportConfiguration, TransportConfiguration>)pair, msg.isBackup());
                    } else {
                        logger.debug((Object)("Cluster connection is null on acceptor = " + this.acceptorUsed));
                    }
                } else {
                    logger.debug((Object)("there is no acceptor used configured at the CoreProtocolManager " + this));
                }
            } else if (packet.getType() == -2) {
                if (ClusterController.this.quorumManager != null) {
                    ClusterController.this.quorumManager.handleQuorumVote(this.clusterChannel, packet);
                } else {
                    logger.warnf("Received %s on a cluster connection that's using the new quorum vote algorithm.", (Object)packet);
                }
            } else if (packet.getType() == -6) {
                ScaleDownAnnounceMessage message = (ScaleDownAnnounceMessage)packet;
                if (ClusterController.this.server.getNodeID().equals((Object)message.getTargetNodeId())) {
                    ClusterController.this.server.addScaledDownNode(message.getScaledDownNodeId());
                }
            } else if (this.channelHandler != null) {
                this.channelHandler.handlePacket(packet);
            }
        }
    }
}

