/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;

public class ReplicaPolicy
extends BackupPolicy {
    private String clusterName;
    private int maxSavedReplicatedJournalsSize = ActiveMQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize();
    private String groupName = null;
    private boolean restartBackup = ActiveMQDefaultConfiguration.isDefaultRestartBackup();
    private boolean allowFailback = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private int quorumSize;
    private boolean voteOnReplicationFailure;
    private ReplicatedPolicy replicatedPolicy;
    private final NetworkHealthCheck networkHealthCheck;
    private int voteRetries;
    private long voteRetryWait;
    private final int quorumVoteWait;
    private long retryReplicationWait;

    public ReplicaPolicy(NetworkHealthCheck networkHealthCheck, int quorumVoteWait) {
        this.networkHealthCheck = networkHealthCheck;
        this.quorumVoteWait = quorumVoteWait;
    }

    public ReplicaPolicy(NetworkHealthCheck networkHealthCheck, ReplicatedPolicy replicatedPolicy, int quorumVoteWait) {
        this.networkHealthCheck = networkHealthCheck;
        this.replicatedPolicy = replicatedPolicy;
        this.quorumVoteWait = quorumVoteWait;
    }

    public ReplicaPolicy(String clusterName, int maxSavedReplicatedJournalsSize, String groupName, boolean restartBackup, boolean allowFailback, long initialReplicationSyncTimeout, ScaleDownPolicy scaleDownPolicy, NetworkHealthCheck networkHealthCheck, boolean voteOnReplicationFailure, int quorumSize, int voteRetries, long voteRetryWait, int quorumVoteWait, long retryReplicationWait) {
        this.clusterName = clusterName;
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        this.groupName = groupName;
        this.restartBackup = restartBackup;
        this.allowFailback = allowFailback;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.quorumSize = quorumSize;
        this.voteRetries = voteRetries;
        this.voteRetryWait = voteRetryWait;
        this.retryReplicationWait = retryReplicationWait;
        this.scaleDownPolicy = scaleDownPolicy;
        this.networkHealthCheck = networkHealthCheck;
        this.voteOnReplicationFailure = voteOnReplicationFailure;
        this.quorumVoteWait = quorumVoteWait;
        this.retryReplicationWait = retryReplicationWait;
    }

    public ReplicaPolicy(String clusterName, int maxSavedReplicatedJournalsSize, String groupName, ReplicatedPolicy replicatedPolicy, NetworkHealthCheck networkHealthCheck, int quorumVoteWait) {
        this.clusterName = clusterName;
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        this.groupName = groupName;
        this.replicatedPolicy = replicatedPolicy;
        this.networkHealthCheck = networkHealthCheck;
        this.quorumVoteWait = quorumVoteWait;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }

    public void setMaxSavedReplicatedJournalsSize(int maxSavedReplicatedJournalsSize) {
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
    }

    public ReplicatedPolicy getReplicatedPolicy() {
        if (this.replicatedPolicy == null) {
            this.replicatedPolicy = new ReplicatedPolicy(false, this.allowFailback, this.initialReplicationSyncTimeout, this.groupName, this.clusterName, this, this.networkHealthCheck, this.voteOnReplicationFailure, this.quorumSize, this.voteRetries, this.voteRetryWait, this.quorumVoteWait);
        }
        return this.replicatedPolicy;
    }

    public void setReplicatedPolicy(ReplicatedPolicy replicatedPolicy) {
        this.replicatedPolicy = replicatedPolicy;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public boolean isRestartBackup() {
        return this.restartBackup;
    }

    @Override
    public void setRestartBackup(boolean restartBackup) {
        this.restartBackup = restartBackup;
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public boolean isAllowFailback() {
        return this.allowFailback;
    }

    public void setAllowFailback(boolean allowFailback) {
        this.allowFailback = allowFailback;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public void setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
    }

    @Override
    public Activation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) throws Exception {
        SharedNothingBackupActivation backupActivation = new SharedNothingBackupActivation(server, wasLive, activationParams, ioCriticalErrorListener, this, this.networkHealthCheck);
        backupActivation.init();
        return backupActivation;
    }

    public void setQuorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public void setVoteOnReplicationFailure(boolean voteOnReplicationFailure) {
        this.voteOnReplicationFailure = voteOnReplicationFailure;
    }

    public boolean isVoteOnReplicationFailure() {
        return this.voteOnReplicationFailure;
    }

    public void setVoteRetries(int voteRetries) {
        this.voteRetries = voteRetries;
    }

    public void setVoteRetryWait(long voteRetryWait) {
        this.voteRetryWait = voteRetryWait;
    }

    public int getVoteRetries() {
        return this.voteRetries;
    }

    public long getVoteRetryWait() {
        return this.voteRetryWait;
    }

    public int getQuorumVoteWait() {
        return this.quorumVoteWait;
    }

    public long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }

    public void setretryReplicationWait(long retryReplicationWait) {
        this.retryReplicationWait = retryReplicationWait;
    }
}

