/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilderServiceNameProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class PassivationStoreRemove
extends ServiceRemoveStepHandler {
    private final Set<RuntimeCapability> unavailableCapabilities;

    public PassivationStoreRemove(AbstractAddStepHandler addOperation) {
        super(addOperation);
        this.unavailableCapabilities = new LinkedHashSet<RuntimeCapability>();
    }

    public PassivationStoreRemove(AbstractAddStepHandler addOperation, RuntimeCapability ... unavailableCapabilities) {
        super(addOperation, unavailableCapabilities);
        this.unavailableCapabilities = new LinkedHashSet<RuntimeCapability>(Arrays.asList(unavailableCapabilities));
    }

    protected ServiceName serviceName(String name) {
        return new DistributableCacheFactoryBuilderServiceNameProvider(name).getServiceName();
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (PassivationStoreRemove.removeInCurrentStep(resource)) {
            Set capabilitySet = this.unavailableCapabilities.isEmpty() ? context.getResourceRegistration().getCapabilities() : this.unavailableCapabilities;
            PathAddress address = context.getCurrentAddress();
            for (RuntimeCapability capability : capabilitySet) {
                if (capability.isDynamicallyNamed()) {
                    context.deregisterCapability(capability.getDynamicName(context.getCurrentAddress()));
                    continue;
                }
                context.deregisterCapability(capability.getName());
            }
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            for (String attributeName : registration.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
                AttributeDefinition attribute = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName).getAttributeDefinition();
                if (!attribute.hasCapabilityRequirements()) continue;
                attribute.removeCapabilityRequirements(context, resource, model.get(attributeName));
            }
            for (CapabilityReferenceRecorder recorder : registration.getRequirements()) {
                recorder.removeCapabilityRequirements(context, resource, null, new String[0]);
            }
        }
        super.performRemove(context, operation, model);
    }

    private static boolean removeInCurrentStep(Resource resource) {
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                if (entry.isRuntime() || !resource.hasChild(entry.getPathElement())) continue;
                return false;
            }
        }
        return true;
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
    }
}

