/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ByteUtils;

public class ByteBufferAccessor
implements Readable,
Writable {
    private final ByteBuffer buf;

    public ByteBufferAccessor(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public byte readByte() {
        return this.buf.get();
    }

    @Override
    public short readShort() {
        return this.buf.getShort();
    }

    @Override
    public int readInt() {
        return this.buf.getInt();
    }

    @Override
    public long readLong() {
        return this.buf.getLong();
    }

    @Override
    public double readDouble() {
        return ByteUtils.readDouble(this.buf);
    }

    @Override
    public void readArray(byte[] arr) {
        this.buf.get(arr);
    }

    @Override
    public int readUnsignedVarint() {
        return ByteUtils.readUnsignedVarint(this.buf);
    }

    @Override
    public ByteBuffer readByteBuffer(int length) {
        ByteBuffer res = this.buf.slice();
        res.limit(length);
        this.buf.position(this.buf.position() + length);
        return res;
    }

    @Override
    public void writeByte(byte val) {
        this.buf.put(val);
    }

    @Override
    public void writeShort(short val) {
        this.buf.putShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.buf.putInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.buf.putLong(val);
    }

    @Override
    public void writeDouble(double val) {
        ByteUtils.writeDouble(val, this.buf);
    }

    @Override
    public void writeByteArray(byte[] arr) {
        this.buf.put(arr);
    }

    @Override
    public void writeUnsignedVarint(int i) {
        ByteUtils.writeUnsignedVarint(i, this.buf);
    }

    @Override
    public void writeByteBuffer(ByteBuffer src) {
        this.buf.put(src.duplicate());
    }

    @Override
    public void writeVarint(int i) {
        ByteUtils.writeVarint(i, this.buf);
    }

    @Override
    public void writeVarlong(long i) {
        ByteUtils.writeVarlong(i, this.buf);
    }

    @Override
    public int readVarint() {
        return ByteUtils.readVarint(this.buf);
    }

    @Override
    public long readVarlong() {
        return ByteUtils.readVarlong(this.buf);
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    public void flip() {
        this.buf.flip();
    }

    public ByteBuffer buffer() {
        return this.buf;
    }
}

