/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;

public class DateTypeDeserializer
extends AbstractDateTimeDeserializer<Date> {
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;

    public DateTypeDeserializer(Customization customization) {
        super(Date.class, customization);
    }

    @Override
    protected Date fromInstant(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    @Override
    protected Date parseDefault(String jsonValue, Locale locale) {
        TemporalAccessor parsed = this.parseWithOrWithoutZone(jsonValue, DEFAULT_DATE_TIME_FORMATTER.withLocale(locale), UTC);
        return new Date(Instant.from(parsed).toEpochMilli());
    }

    @Override
    protected Date parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        TemporalAccessor parsed = this.parseWithOrWithoutZone(jsonValue, formatter, UTC);
        return new Date(Instant.from(parsed).toEpochMilli());
    }

    private TemporalAccessor parseWithOrWithoutZone(String jsonValue, DateTimeFormatter formatter, ZoneId defaultZone) {
        try {
            return ZonedDateTime.parse(jsonValue, formatter);
        }
        catch (DateTimeParseException e) {
            return ZonedDateTime.parse(jsonValue, formatter.withZone(defaultZone));
        }
    }
}

