/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.wildfly.core.jar.runtime.BootableEnvironment;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

class InstallationCleaner
implements Runnable {
    private final BootableEnvironment environment;
    private final Path cleanupMarker;
    private final BootableJarLogger logger;
    private final boolean newProcess;
    private final int retries;

    InstallationCleaner(BootableEnvironment environment, BootableJarLogger logger2) {
        this.environment = environment;
        this.cleanupMarker = environment.getJBossHome().resolve("wildfly-cleanup-marker");
        this.logger = logger2;
        this.newProcess = InstallationCleaner.getProperty("org.wildfly.core.jar.cleanup.newProcess", environment.isWindows());
        this.retries = InstallationCleaner.getProperty("org.wildfly.core.jar.cleanup.retries", 3);
    }

    @Override
    public void run() {
        if (Files.notExists(this.cleanupMarker, new LinkOption[0])) {
            try {
                Files.createFile(this.cleanupMarker, new FileAttribute[0]);
                long timeout = this.environment.getTimeout() * 1000L;
                Path pidFile = this.environment.getPidFile();
                long wait = 500L;
                while (Files.exists(pidFile, new LinkOption[0])) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException ignore) {
                        break;
                    }
                    if ((timeout -= 500L) > 0L) continue;
                    this.logger.cleanupTimeout(this.environment.getTimeout(), pidFile);
                    break;
                }
                this.cleanup();
            }
            catch (IOException e) {
                this.logger.failedToStartCleanupProcess(e, this.environment.getJBossHome());
            }
        }
    }

    void cleanup() throws IOException {
        if (this.newProcess) {
            try {
                this.newProcess();
            }
            catch (IOException e) {
                IOException suppressed = null;
                try {
                    this.deleteDirectory();
                }
                catch (IOException ex) {
                    suppressed = ex;
                }
                if (suppressed != null) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
        }
        this.deleteDirectory();
    }

    private void deleteDirectory() throws IOException {
        final Path installDir = this.environment.getJBossHome();
        Files.walkFileTree(installDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                try {
                    if (!file.equals(InstallationCleaner.this.cleanupMarker)) {
                        Files.delete(file);
                    }
                }
                catch (IOException e) {
                    InstallationCleaner.this.logger.cantDelete(file.toString(), e);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                try {
                    if (dir.equals(installDir)) {
                        Files.deleteIfExists(InstallationCleaner.this.cleanupMarker);
                    }
                    Files.delete(dir);
                }
                catch (IOException e) {
                    InstallationCleaner.this.logger.cantDelete(dir.toString(), e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void newProcess() throws IOException {
        String[] cmd = new String[]{this.getJavaCommand(), "-cp", System.getProperty("java.class.path"), "org.wildfly.core.jar.boot.CleanupProcessor", this.environment.getJBossHome().toString(), Integer.toString(this.retries)};
        ProcessBuilder builder = new ProcessBuilder(cmd).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).directory(new File(System.getProperty("user.dir")));
        builder.start();
    }

    private String getJavaCommand() {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        Path java = this.environment.isWindows() ? javaHome.resolve("bin").resolve("java.exe") : javaHome.resolve("bin").resolve("java");
        if (Files.exists(java, new LinkOption[0])) {
            return java.toString();
        }
        return "java";
    }

    private static boolean getProperty(String key, boolean dft) {
        String value = System.getProperty(key);
        if (value == null) {
            return dft;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    private static int getProperty(String key, int dft) {
        String value = System.getProperty(key);
        if (value == null) {
            return dft;
        }
        return Integer.parseInt(value);
    }
}

