/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.revisioninfo;

import java.util.Date;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class RevisionInfoQueryCreator {
    private static final String REVISION_DATE_QUERY = "SELECT %s FROM %s WHERE %s = :revision";
    private static final String REVISION_DATE_QUERY_PARAMETER = "revision";
    private static final String REVISION_NUMBER_FOR_DATE_QUERY = "SELECT MAX(%s) FROM %s WHERE %s <= :date";
    private static final String REVISION_NUMBER_FOR_DATE_QUERY_PARAMETER = "date";
    private static final String REVISIONS_QUERY = "FROM %s WHERE %s IN (:revisions)";
    private static final String REVISIONS_QUERY_PARAMETER = "revisions";
    private final String revisionInfoEntityName;
    private final String revisionInfoIdName;
    private final String revisionInfoTimestampName;
    private final boolean timestampAsDate;

    public RevisionInfoQueryCreator(String revisionInfoEntityName, String revisionInfoIdName, String revisionInfoTimestampName, boolean timestampAsDate) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.revisionInfoIdName = revisionInfoIdName;
        this.revisionInfoTimestampName = revisionInfoTimestampName;
        this.timestampAsDate = timestampAsDate;
    }

    public Query<?> getRevisionDateQuery(Session session, Number revision) {
        return session.createQuery(String.format(REVISION_DATE_QUERY, this.revisionInfoTimestampName, this.revisionInfoEntityName, this.revisionInfoIdName)).setParameter(REVISION_DATE_QUERY_PARAMETER, (Object)revision);
    }

    public Query<?> getRevisionNumberForDateQuery(Session session, Date date) {
        return session.createQuery(String.format(REVISION_NUMBER_FOR_DATE_QUERY, this.revisionInfoIdName, this.revisionInfoEntityName, this.revisionInfoTimestampName)).setParameter(REVISION_NUMBER_FOR_DATE_QUERY_PARAMETER, (Object)(this.timestampAsDate ? date : Long.valueOf(date.getTime())));
    }

    public Query<?> getRevisionsQuery(Session session, Set<Number> revisions) {
        return session.createQuery(String.format(REVISIONS_QUERY, this.revisionInfoEntityName, this.revisionInfoIdName)).setParameter(REVISIONS_QUERY_PARAMETER, revisions);
    }
}

