/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterLoadBalancingGroupDefinition;
import org.wildfly.extension.undertow.filters.ModClusterNodeDefinition;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;

class ModClusterBalancerDefinition
extends SimpleResourceDefinition {
    public static final ModClusterBalancerDefinition INSTANCE = new ModClusterBalancerDefinition();
    public static final AttributeDefinition STICKY_SESSION_COOKIE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sticky-session-cookie", ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition STICKY_SESSION_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sticky-session-path", ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition MAX_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-attempts", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition WAIT_WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("wait-worker", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition STICKY_SESSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sticky-session", ModelType.BOOLEAN).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition STICKY_SESSION_FORCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sticky-session-force", ModelType.BOOLEAN).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition STICKY_SESSION_REMOVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sticky-session-remove", ModelType.BOOLEAN).setRequired(false)).setStorageRuntime()).build();

    private ModClusterBalancerDefinition() {
        super(new SimpleResourceDefinition.Parameters(UndertowExtension.BALANCER, (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "mod-cluster", "balancer")).setRuntime());
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)ModClusterNodeDefinition.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)ModClusterLoadBalancingGroupDefinition.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(MAX_ATTEMPTS, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getMaxAttempts()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(STICKY_SESSION_COOKIE, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                String stickySessionCookie = ctx.getStickySessionCookie();
                if (stickySessionCookie == null) {
                    context.getResult().set(new ModelNode());
                } else {
                    context.getResult().set(new ModelNode(stickySessionCookie));
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute(STICKY_SESSION_PATH, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                String stickySessionPath = ctx.getStickySessionPath();
                if (stickySessionPath == null) {
                    context.getResult().set(new ModelNode());
                } else {
                    context.getResult().set(new ModelNode(stickySessionPath));
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute(WAIT_WORKER, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getWaitWorker()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(STICKY_SESSION, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.isStickySession()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(STICKY_SESSION_REMOVE, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.isStickySessionRemove()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(STICKY_SESSION_FORCE, (OperationStepHandler)new AbstractBalancerOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.LoadBalancer ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.isStickySessionForce()));
            }
        });
    }

    private abstract class AbstractBalancerOperation
    implements OperationStepHandler {
        private AbstractBalancerOperation() {
        }

        public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String modClusterName;
            ModClusterService service;
            PathAddress address = context.getCurrentAddress();
            int current = address.size() - 1;
            String balancerName = address.getElement(current--).getValue();
            if ((service = ModClusterResource.service(modClusterName = address.getElement(current--).getValue())) == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.LoadBalancer balancer = service.getModCluster().getController().getStatus().getLoadBalancer(balancerName);
            if (balancer == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            this.handleNode(context, balancer, operation);
        }

        protected abstract void handleNode(OperationContext var1, ModClusterStatus.LoadBalancer var2, ModelNode var3) throws OperationFailedException;
    }
}

