/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.cache.BrowserCache;

public class CacheEntry
implements BrowserCache.Entry,
Serializable {
    private static final long serialVersionUID = -1922521972113619372L;
    private final String mediaType;
    private final byte[] cached;
    private final int expires;
    private final long timestamp = System.currentTimeMillis();
    private final MultivaluedMap<String, String> headers;
    private BrowserCache.Header[] validationHeaders = new BrowserCache.Header[0];
    private final String key;
    private Map<Serializable, Serializable> extendedProperties = new ConcurrentHashMap<Serializable, Serializable>();

    public CacheEntry(String key, MultivaluedMap<String, String> headers, byte[] cached, int expires, String etag, String lastModified, MediaType mediaType) {
        this.key = key;
        this.cached = cached;
        this.expires = expires;
        this.mediaType = mediaType.toString();
        this.headers = headers;
        if (etag != null || lastModified != null) {
            if (etag != null && lastModified != null) {
                this.validationHeaders = new BrowserCache.Header[2];
                this.validationHeaders[0] = new BrowserCache.Header("If-Modified-Since", lastModified);
                this.validationHeaders[1] = new BrowserCache.Header("If-None-Match", etag);
            } else if (etag != null) {
                this.validationHeaders = new BrowserCache.Header[1];
                this.validationHeaders[0] = new BrowserCache.Header("If-None-Match", etag);
            } else if (lastModified != null) {
                this.validationHeaders = new BrowserCache.Header[1];
                this.validationHeaders[0] = new BrowserCache.Header("If-Modified-Since", lastModified);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean expired() {
        return System.currentTimeMillis() - this.timestamp >= (long)this.expires * 1000L;
    }

    @Override
    public BrowserCache.Header[] getValidationHeaders() {
        return this.validationHeaders;
    }

    @Override
    public byte[] getCached() {
        return this.cached;
    }

    @Override
    public MediaType getMediaType() {
        return MediaType.valueOf((String)this.mediaType);
    }

    public void addExtendedProperty(Serializable key, Serializable value) {
        this.extendedProperties.put(key, value);
    }

    public Object getExtendedProperty(Serializable key) {
        return this.extendedProperties.get(key);
    }
}

