/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.nio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;

public class MockSocketChannel
extends SocketChannel {
    protected int bytes_to_write;
    protected ByteBuffer bytes_to_read;
    protected boolean closed = false;
    protected ByteBuffer recorder;

    public MockSocketChannel() {
        super(null);
    }

    public MockSocketChannel(SelectorProvider provider) {
        super(provider);
    }

    public MockSocketChannel bytesToWrite(int num) {
        this.bytes_to_write = num;
        return this;
    }

    public MockSocketChannel bytesToRead(byte[] buf) {
        this.bytes_to_read = ByteBuffer.wrap(buf);
        return this;
    }

    public MockSocketChannel bytesToRead(ByteBuffer buf) {
        this.bytes_to_read = buf;
        return this;
    }

    public ByteBuffer bytesToRead() {
        return this.bytes_to_read;
    }

    public MockSocketChannel recorder(ByteBuffer buf) {
        this.recorder = buf;
        return this;
    }

    public ByteBuffer recorder() {
        return this.recorder;
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        return null;
    }

    public void doClose() {
        this.closed = true;
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return null;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return null;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return null;
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return null;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return null;
    }

    @Override
    public Socket socket() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isConnectionPending() {
        return false;
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        return true;
    }

    @Override
    public boolean finishConnect() throws IOException {
        return true;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return null;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = 0;
        while (dst.hasRemaining() && this.bytes_to_read.hasRemaining()) {
            dst.put(this.bytes_to_read.get());
            ++read;
        }
        return read > 0 ? read : (this.closed ? -1 : read);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer buf;
            ByteBuffer byteBuffer = buf = i >= 0 && i < dsts.length ? dsts[i] : null;
            if (buf == null) continue;
            int read = this.read(buf);
            if (read >= 0) {
                total += (long)read;
                continue;
            }
            return read;
        }
        return total;
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        if (this.bytes_to_write == 0) {
            return 0;
        }
        int written = 0;
        while (buf.hasRemaining() && this.bytes_to_write-- > 0) {
            byte b = buf.get();
            ++written;
            if (this.recorder == null) continue;
            this.recorder.put(b);
        }
        return written;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.bytes_to_write == 0) {
            return 0L;
        }
        int written = 0;
        for (int i = offset; i < Math.min(srcs.length, length + offset); ++i) {
            ByteBuffer buf = srcs[i];
            while (buf.hasRemaining() && this.bytes_to_write-- > 0) {
                byte b = buf.get();
                ++written;
                if (this.recorder == null) continue;
                this.recorder.put(b);
            }
        }
        return written;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return null;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
    }
}

