/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import java.util.EnumSet;

public enum NtfsAttributes {
    READ_ONLY,
    HIDDEN,
    SYSTEM,
    NORMAL,
    DIRECTORY,
    ARCHIVE,
    TEMPORARY,
    OFFLINE,
    NOT_CONTENT_INDEXED,
    NO_SCRUB_DATA;


    public static String toString(EnumSet<NtfsAttributes> ntfsAttributes) {
        if (ntfsAttributes == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (ntfsAttributes.contains((Object)READ_ONLY)) {
            builder.append("ReadOnly|");
        }
        if (ntfsAttributes.contains((Object)HIDDEN)) {
            builder.append("Hidden|");
        }
        if (ntfsAttributes.contains((Object)SYSTEM)) {
            builder.append("System|");
        }
        if (ntfsAttributes.contains((Object)NORMAL)) {
            builder.append("None|");
        }
        if (ntfsAttributes.contains((Object)DIRECTORY)) {
            builder.append("Directory|");
        }
        if (ntfsAttributes.contains((Object)ARCHIVE)) {
            builder.append("Archive|");
        }
        if (ntfsAttributes.contains((Object)TEMPORARY)) {
            builder.append("Temporary|");
        }
        if (ntfsAttributes.contains((Object)OFFLINE)) {
            builder.append("Offline|");
        }
        if (ntfsAttributes.contains((Object)NOT_CONTENT_INDEXED)) {
            builder.append("NotContentIndexed|");
        }
        if (ntfsAttributes.contains((Object)NO_SCRUB_DATA)) {
            builder.append("NoScrubData|");
        }
        builder.deleteCharAt(builder.lastIndexOf("|"));
        return builder.toString();
    }

    public static EnumSet<NtfsAttributes> toAttributes(String ntfsAttributes) {
        String[] splitAttributes;
        EnumSet<NtfsAttributes> attributes = EnumSet.noneOf(NtfsAttributes.class);
        for (String sa : splitAttributes = ntfsAttributes.split("\\|")) {
            if (sa.equals("ReadOnly")) {
                attributes.add(READ_ONLY);
                continue;
            }
            if (sa.equals("Hidden")) {
                attributes.add(HIDDEN);
                continue;
            }
            if (sa.equals("System")) {
                attributes.add(SYSTEM);
                continue;
            }
            if (sa.equals("None")) {
                attributes.add(NORMAL);
                continue;
            }
            if (sa.equals("Directory")) {
                attributes.add(DIRECTORY);
                continue;
            }
            if (sa.equals("Archive")) {
                attributes.add(ARCHIVE);
                continue;
            }
            if (sa.equals("Temporary")) {
                attributes.add(TEMPORARY);
                continue;
            }
            if (sa.equals("Offline")) {
                attributes.add(OFFLINE);
                continue;
            }
            if (sa.equals("NotContentIndexed")) {
                attributes.add(NOT_CONTENT_INDEXED);
                continue;
            }
            if (sa.equals("NoScrubData")) {
                attributes.add(NO_SCRUB_DATA);
                continue;
            }
            throw new IllegalArgumentException("value");
        }
        return attributes;
    }
}

