/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

@Deprecated
public class AsynchronousServiceBuilder<T>
implements Builder<T>,
Service<T>,
Supplier<Service<T>> {
    private static final ServiceName EXECUTOR_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"as", "server-executor"});
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    private final Service<T> service;
    private final ServiceName name;
    private volatile boolean startAsynchronously = true;
    private volatile boolean stopAsynchronously = true;

    public AsynchronousServiceBuilder(ServiceName name, Service<T> service) {
        this.name = name;
        this.service = service;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        return target.addService(this.name, (Service)this).addDependency(EXECUTOR_SERVICE_NAME, ExecutorService.class, this.executor);
    }

    @Override
    public Service<T> get() {
        return this.service;
    }

    public AsynchronousServiceBuilder<T> startSynchronously() {
        this.startAsynchronously = false;
        return this;
    }

    public AsynchronousServiceBuilder<T> stopSynchronously() {
        this.stopAsynchronously = false;
        return this;
    }

    public T getValue() {
        return (T)this.service.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        if (this.startAsynchronously) {
            Runnable task = () -> {
                try {
                    this.service.start(context);
                    context.complete();
                }
                catch (StartException e) {
                    context.failed(e);
                }
                catch (Throwable e) {
                    context.failed(new StartException(e));
                }
            };
            try {
                ((ExecutorService)this.executor.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.service.start(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        if (this.stopAsynchronously) {
            Runnable task = () -> {
                try {
                    this.service.stop(context);
                }
                finally {
                    context.complete();
                }
            };
            try {
                ((ExecutorService)this.executor.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.service.stop(context);
        }
    }
}

