/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.CoordinatorCompletionCoordinatorInboundEvents;
import com.arjuna.webservices11.wsba.client.CoordinatorCompletionParticipantClient;
import com.arjuna.webservices11.wsba.processors.CoordinatorCompletionCoordinatorProcessor;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.wsc11.messaging.MessageId;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsba._2006._06.ExceptionType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;

public class CoordinatorCompletionCoordinatorProcessorImpl
extends CoordinatorCompletionCoordinatorProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateCoordinator(CoordinatorCompletionCoordinatorInboundEvents coordinator, String identifier) {
        this.activatedObjectProcessor.activateObject(coordinator, identifier);
    }

    @Override
    public void deactivateCoordinator(CoordinatorCompletionCoordinatorInboundEvents coordinator) {
        this.activatedObjectProcessor.deactivateObject(coordinator);
    }

    @Override
    public CoordinatorCompletionCoordinatorInboundEvents getCoordinator(String identifier) {
        return (CoordinatorCompletionCoordinatorInboundEvents)this.activatedObjectProcessor.getObject(identifier);
    }

    private CoordinatorCompletionCoordinatorInboundEvents getCoordinator(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (CoordinatorCompletionCoordinatorInboundEvents)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public void cancelled(NotificationType cancelled, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.cancelled(cancelled, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from cancelled:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Cancelled called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void closed(NotificationType closed, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.closed(closed, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from closed:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Closed called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void compensated(NotificationType compensated, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.compensated(compensated, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from compensated:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Compensated called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void fail(ExceptionType fail, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.fail(fail, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from failed:", (Object)th);
                }
            }
        } else if (CoordinatorCompletionCoordinatorProcessorImpl.areRecoveryLogEntriesAccountedFor()) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Failed called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
            }
            this.sendFailed(map, arjunaContext);
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Ignoring fail called on unidentified coordinator until recovery pass is complete: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void completed(NotificationType completed, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.completed(completed, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from completed:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            if (CoordinatorCompletionCoordinatorProcessorImpl.areRecoveryLogEntriesAccountedFor()) {
                WSTLogger.logger.tracev("Completed called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
            } else {
                WSTLogger.logger.tracev("Ignoring completed called on unidentified coordinator until recovery pass is complete: {0}", new Object[]{instanceIdentifier});
            }
        }
    }

    @Override
    public void exit(NotificationType exit, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.exit(exit, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from exit:", (Object)th);
                }
            }
        } else {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Exit called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
            }
            this.sendExited(map, arjunaContext);
        }
    }

    @Override
    public void cannotComplete(NotificationType cannotComplete, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.cannotComplete(cannotComplete, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from cannotComplete:", (Object)th);
                }
            }
        } else {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("cannotComplete called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
            }
            this.sendNotCompleted(map, arjunaContext);
        }
    }

    @Override
    public void getStatus(NotificationType getStatus, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
            if (coordinator != null) {
                try {
                    coordinator.getStatus(getStatus, map, arjunaContext);
                }
                catch (Throwable th) {
                    if (WSTLogger.logger.isTraceEnabled()) {
                        WSTLogger.logger.tracev("Unexpected exception thrown from getStatus:", (Object)th);
                    }
                    break block10;
                }
            }
            if (!CoordinatorCompletionCoordinatorProcessorImpl.areRecoveryLogEntriesAccountedFor()) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("GetStatus dropped for unknown coordinator completion participant {0} while waiting on recovery scan", new Object[]{instanceIdentifier});
                }
            } else {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("GetStatus called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
                }
                String messageId = MessageId.getMessageId();
                MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                try {
                    SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CoordinatorCompletionCoordinatorProcessorImpl_getStatus_4());
                    CoordinatorCompletionParticipantClient.getClient().sendSoapFault(soapFault, null, faultMAP, CoordinatorCompletionCoordinatorProcessorImpl.getFaultAction());
                }
                catch (Throwable th) {
                    WSTLogger.i18NLogger.info_wst11_messaging_CoordinatorCompletionCoordinatorProcessorImpl_getStatus_3(instanceIdentifier.toString(), th);
                }
            }
        }
    }

    private static String getFaultAction() {
        return "http://docs.oasis-open.org/ws-tx/wscoor/2006/06/fault";
    }

    @Override
    public void status(StatusType status, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.status(status, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from status:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Status called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        CoordinatorCompletionCoordinatorInboundEvents coordinator = this.getCoordinator(instanceIdentifier);
        if (coordinator != null) {
            try {
                coordinator.soapFault(soapFault, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from soapFault:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("SoapFault called on unknown coordinator: {0}", new Object[]{instanceIdentifier});
        }
    }

    private void sendExited(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseAddressingContext = AddressingHelper.createOneWayResponseContext(map, messageId);
            try {
                CoordinatorCompletionParticipantClient.getClient().sendExited(null, responseAddressingContext, arjunaContext.getInstanceIdentifier());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Exited", (Object)th);
            }
        }
    }

    private void sendFailed(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseAddressingContext = AddressingHelper.createOneWayResponseContext(map, messageId);
            try {
                CoordinatorCompletionParticipantClient.getClient().sendFailed(null, responseAddressingContext, arjunaContext.getInstanceIdentifier());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Faulted", (Object)th);
            }
        }
    }

    private void sendNotCompleted(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseAddressingContext = AddressingHelper.createOneWayResponseContext(map, messageId);
            try {
                CoordinatorCompletionParticipantClient.getClient().sendNotCompleted(null, responseAddressingContext, arjunaContext.getInstanceIdentifier());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending NotCompleted", (Object)th);
            }
        }
    }

    private static boolean areRecoveryLogEntriesAccountedFor() {
        return XTSBARecoveryManager.getRecoveryManager().isCoordinatorRecoveryStarted() && XTSBARecoveryManager.getRecoveryManager().isSubordinateCoordinatorRecoveryStarted();
    }
}

