/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;

public class ClasspathURLStreamHandler
implements URLStreamHandlerFactory {
    private static final URLStreamHandlerFactory INSTANCE = new ClasspathURLStreamHandler();

    public static void register() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                URL.setURLStreamHandlerFactory(INSTANCE);
                return null;
            });
        } else {
            URL.setURLStreamHandlerFactory(INSTANCE);
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("classpath".equals(protocol)) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    URL resource;
                    String path = u.getPath();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    URL uRL = resource = classLoader == null ? null : classLoader.getResource(path);
                    if (resource == null) {
                        resource = ClassLoader.getSystemClassLoader().getResource(path);
                    }
                    if (resource != null) {
                        return resource.openConnection();
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

