/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.InjectiveFunction;

public class SpliteratorMapper<E, S>
implements CloseableSpliterator<S> {
    protected final Spliterator<E> spliterator;
    protected final Function<? super E, ? extends S> mapper;

    public SpliteratorMapper(Spliterator<E> spliterator, Function<? super E, ? extends S> mapper) {
        this.spliterator = Objects.requireNonNull(spliterator);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public boolean tryAdvance(Consumer<? super S> action) {
        return this.spliterator.tryAdvance((? super T e) -> action.accept((S)this.mapper.apply(e)));
    }

    @Override
    public Spliterator<S> trySplit() {
        Spliterator<E> split = this.spliterator.trySplit();
        if (split != null) {
            return new SpliteratorMapper<E, S>(split, this.mapper);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.spliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        int characteristics = this.spliterator.characteristics();
        if (this.mapper instanceof InjectiveFunction) {
            return characteristics;
        }
        return characteristics & 0xFFFFFFFE;
    }

    @Override
    public void forEachRemaining(Consumer<? super S> action) {
        this.spliterator.forEachRemaining((? super T e) -> action.accept((S)this.mapper.apply(e)));
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.spliterator.getExactSizeIfKnown();
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return this.spliterator.hasCharacteristics(characteristics);
    }

    @Override
    public void close() {
        if (this.spliterator instanceof CloseableSpliterator) {
            ((CloseableSpliterator)this.spliterator).close();
        }
    }
}

