/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.EventBusInternal;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.eventbus.impl.MessageConsumerImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageProducerImpl;
import io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import io.vertx.core.eventbus.impl.ReplyHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class EventBusImpl
implements EventBusInternal,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(EventBusImpl.class);
    private final List<Handler<DeliveryContext>> sendInterceptors = new CopyOnWriteArrayList<Handler<DeliveryContext>>();
    private final List<Handler<DeliveryContext>> receiveInterceptors = new CopyOnWriteArrayList<Handler<DeliveryContext>>();
    private final AtomicLong replySequence = new AtomicLong(0L);
    protected final VertxInternal vertx;
    protected final EventBusMetrics metrics;
    protected final ConcurrentMap<String, ConcurrentCyclicSequence<HandlerHolder>> handlerMap = new ConcurrentHashMap<String, ConcurrentCyclicSequence<HandlerHolder>>();
    protected final CodecManager codecManager = new CodecManager();
    protected volatile boolean started;

    public EventBusImpl(VertxInternal vertx) {
        VertxMetrics metrics = vertx.metricsSPI();
        this.vertx = vertx;
        this.metrics = metrics != null ? metrics.createEventBusMetrics() : null;
    }

    @Override
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.sendInterceptors.add(interceptor);
        return this;
    }

    @Override
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.receiveInterceptors.add(interceptor);
        return this;
    }

    @Override
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.sendInterceptors.remove(interceptor);
        return this;
    }

    Iterator<Handler<DeliveryContext>> receiveInterceptors() {
        return this.receiveInterceptors.iterator();
    }

    @Override
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.receiveInterceptors.remove(interceptor);
        return this;
    }

    @Override
    public synchronized void start(Promise<Void> promise) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        promise.complete();
    }

    @Override
    public EventBus send(String address, Object message) {
        return this.send(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus send(String address, Object message, DeliveryOptions options) {
        MessageImpl msg = this.createMessage(true, address, options.getHeaders(), message, options.getCodecName());
        this.sendOrPubInternal(msg, options, null, null);
        return this;
    }

    @Override
    public <T> Future<Message<T>> request(String address, Object message, DeliveryOptions options) {
        MessageImpl msg = this.createMessage(true, address, options.getHeaders(), message, options.getCodecName());
        ReplyHandler<T> handler = this.createReplyHandler(msg, true, options);
        this.sendOrPubInternal(msg, options, handler, null);
        return handler.result();
    }

    @Override
    public <T> MessageProducer<T> sender(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, true, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, true, options);
    }

    @Override
    public <T> MessageProducer<T> publisher(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, false, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, false, options);
    }

    @Override
    public EventBus publish(String address, Object message) {
        return this.publish(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.sendOrPubInternal(this.createMessage(false, address, options.getHeaders(), message, options.getCodecName()), options, null, null);
        return this;
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, false);
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.consumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, true);
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.localConsumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public EventBus registerCodec(MessageCodec codec) {
        this.codecManager.registerCodec(codec);
        return this;
    }

    @Override
    public EventBus unregisterCodec(String name) {
        this.codecManager.unregisterCodec(name);
        return this;
    }

    @Override
    public <T> EventBus registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        this.codecManager.registerDefaultCodec(clazz, codec);
        return this;
    }

    @Override
    public EventBus unregisterDefaultCodec(Class clazz) {
        this.codecManager.unregisterDefaultCodec(clazz);
        return this;
    }

    @Override
    public void close(Promise<Void> promise) {
        if (!this.started) {
            promise.complete();
            return;
        }
        this.unregisterAll().onComplete(ar -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            promise.handle((AsyncResult<Void>)ar);
        });
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public EventBusMetrics<?> getMetrics() {
        return this.metrics;
    }

    public MessageImpl createMessage(boolean send, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName);
        MessageImpl msg = new MessageImpl(address, headers, body, codec, send, this);
        return msg;
    }

    protected <T> HandlerHolder<T> addRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, Promise<Void> promise) {
        HandlerHolder<T> holder = this.addLocalRegistration(address, registration, replyHandler, localOnly);
        this.onLocalRegistration(holder, promise);
        return holder;
    }

    protected <T> void onLocalRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        if (promise != null) {
            promise.complete();
        }
    }

    private <T> HandlerHolder<T> addLocalRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly) {
        Objects.requireNonNull(address, "address");
        ContextInternal context = registration.context;
        HandlerHolder<T> holder = this.createHandlerHolder(registration, replyHandler, localOnly, context);
        ConcurrentCyclicSequence<HandlerHolder<T>> handlers = new ConcurrentCyclicSequence<HandlerHolder<T>>().add(holder);
        ConcurrentCyclicSequence actualHandlers = this.handlerMap.merge(address, handlers, (old, prev) -> old.add(prev.first()));
        if (context.isDeployment()) {
            context.addCloseHook(registration);
        }
        return holder;
    }

    protected <T> HandlerHolder<T> createHandlerHolder(HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, ContextInternal context) {
        return new HandlerHolder<T>(registration, replyHandler, localOnly, context);
    }

    protected <T> void removeRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        this.removeLocalRegistration(handlerHolder);
        this.onLocalUnregistration(handlerHolder, promise);
    }

    protected <T> void onLocalUnregistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        promise.complete();
    }

    private <T> void removeLocalRegistration(HandlerHolder<T> holder) {
        String address = holder.getHandler().address;
        this.handlerMap.compute(address, (key, val) -> {
            if (val == null) {
                return null;
            }
            ConcurrentCyclicSequence<HandlerHolder> next = val.remove(holder);
            return next.size() == 0 ? null : next;
        });
        if (holder.setRemoved() && holder.getContext().deploymentID() != null) {
            holder.getContext().removeCloseHook(holder.getHandler());
        }
    }

    protected <T> void sendReply(MessageImpl replyMessage, DeliveryOptions options, ReplyHandler<T> replyHandler) {
        if (replyMessage.address() == null) {
            throw new IllegalStateException("address not specified");
        }
        this.sendOrPubInternal(new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), replyMessage, options, replyHandler, null));
    }

    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        this.sendLocally(sendContext);
    }

    protected void callCompletionHandlerAsync(Handler<AsyncResult<Void>> completionHandler) {
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    private <T> void sendLocally(OutboundDeliveryContext<T> sendContext) {
        ReplyException failure = this.deliverMessageLocally(sendContext.message);
        if (failure != null) {
            sendContext.written(failure);
        } else {
            sendContext.written(null);
        }
    }

    protected boolean isMessageLocal(MessageImpl msg) {
        return true;
    }

    protected ReplyException deliverMessageLocally(MessageImpl msg) {
        ConcurrentCyclicSequence handlers = (ConcurrentCyclicSequence)this.handlerMap.get(msg.address());
        if (handlers != null) {
            if (msg.isSend()) {
                HandlerHolder holder = (HandlerHolder)handlers.next();
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), this.isMessageLocal(msg), holder != null ? 1 : 0);
                }
                if (holder != null) {
                    holder.handler.receive(msg.copyBeforeReceive());
                }
            } else {
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), this.isMessageLocal(msg), handlers.size());
                }
                for (HandlerHolder holder : handlers) {
                    holder.handler.receive(msg.copyBeforeReceive());
                }
            }
            return null;
        }
        if (this.metrics != null) {
            this.metrics.messageReceived(msg.address(), !msg.isSend(), this.isMessageLocal(msg), 0);
        }
        return new ReplyException(ReplyFailure.NO_HANDLERS, "No handlers for address " + msg.address);
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Event Bus is not started");
        }
    }

    protected String generateReplyAddress() {
        return "__vertx.reply." + Long.toString(this.replySequence.incrementAndGet());
    }

    <T> ReplyHandler<T> createReplyHandler(MessageImpl message, boolean src, DeliveryOptions options) {
        long timeout = options.getSendTimeout();
        String replyAddress = this.generateReplyAddress();
        message.setReplyAddress(replyAddress);
        ReplyHandler handler = new ReplyHandler(this, this.vertx.getOrCreateContext(), replyAddress, message.address, src, timeout);
        handler.register();
        return handler;
    }

    public <T> OutboundDeliveryContext<T> newSendContext(MessageImpl message, DeliveryOptions options, ReplyHandler<T> handler, Promise<Void> writePromise) {
        return new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), message, options, handler, writePromise);
    }

    public <T> void sendOrPubInternal(OutboundDeliveryContext<T> senderCtx) {
        this.checkStarted();
        senderCtx.iter = this.sendInterceptors.iterator();
        senderCtx.bus = this;
        senderCtx.metrics = this.metrics;
        senderCtx.next();
    }

    public <T> void sendOrPubInternal(MessageImpl message, DeliveryOptions options, ReplyHandler<T> handler, Promise<Void> writePromise) {
        this.checkStarted();
        this.sendOrPubInternal(this.newSendContext(message, options, handler, writePromise));
    }

    private Future<Void> unregisterAll() {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ConcurrentCyclicSequence handlers : this.handlerMap.values()) {
            for (HandlerHolder holder : handlers) {
                futures.add(holder.getHandler().unregister());
            }
        }
        return CompositeFuture.join(futures).mapEmpty();
    }
}

