/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.weld.WeldJBossAll10Parser;
import org.jboss.as.weld.WeldJBossAll11Parser;
import org.jboss.as.weld.WeldJBossAllConfiguration;
import org.jboss.as.weld.WeldResourceDefinition;
import org.jboss.as.weld.deployment.CdiAnnotationProcessor;
import org.jboss.as.weld.deployment.processors.BeanArchiveProcessor;
import org.jboss.as.weld.deployment.processors.BeanDefiningAnnotationProcessor;
import org.jboss.as.weld.deployment.processors.BeansXmlProcessor;
import org.jboss.as.weld.deployment.processors.DevelopmentModeProcessor;
import org.jboss.as.weld.deployment.processors.EarApplicationScopedObserverMethodProcessor;
import org.jboss.as.weld.deployment.processors.ExternalBeanArchiveProcessor;
import org.jboss.as.weld.deployment.processors.WebIntegrationProcessor;
import org.jboss.as.weld.deployment.processors.WeldBeanManagerServiceProcessor;
import org.jboss.as.weld.deployment.processors.WeldComponentIntegrationProcessor;
import org.jboss.as.weld.deployment.processors.WeldConfigurationProcessor;
import org.jboss.as.weld.deployment.processors.WeldDependencyProcessor;
import org.jboss.as.weld.deployment.processors.WeldDeploymentCleanupProcessor;
import org.jboss.as.weld.deployment.processors.WeldDeploymentProcessor;
import org.jboss.as.weld.deployment.processors.WeldImplicitDeploymentProcessor;
import org.jboss.as.weld.deployment.processors.WeldPortableExtensionProcessor;
import org.jboss.as.weld.services.TCCLSingletonService;
import org.jboss.as.weld.services.bootstrap.WeldExecutorServices;
import org.jboss.as.weld.spi.DeploymentUnitProcessorProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.manager.WildFlySecurityManager;

class WeldSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    WeldSubsystemAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        final boolean requireBeanDescriptor = WeldResourceDefinition.REQUIRE_BEAN_DESCRIPTOR_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
        final boolean legacyEmptyBeansXmlTreatment = WeldResourceDefinition.LEGACY_EMPTY_BEANS_XML_TREATMENT_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
        final boolean nonPortableMode = WeldResourceDefinition.NON_PORTABLE_MODE_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
        final boolean developmentMode = WeldResourceDefinition.DEVELOPMENT_MODE_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
        int threadPoolSize = WeldResourceDefinition.THREAD_POOL_SIZE_ATTRIBUTE.resolveModelAttribute(context, model).asInt(WeldExecutorServices.DEFAULT_BOUND);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                JBossAllXmlParserRegisteringProcessor jbossAllParsers = JBossAllXmlParserRegisteringProcessor.builder().addParser(WeldJBossAll10Parser.ROOT_ELEMENT, WeldJBossAllConfiguration.ATTACHMENT_KEY, (JBossAllXMLParser)WeldJBossAll10Parser.INSTANCE).addParser(WeldJBossAll11Parser.ROOT_ELEMENT, WeldJBossAllConfiguration.ATTACHMENT_KEY, (JBossAllXMLParser)WeldJBossAll11Parser.INSTANCE).build();
                processorTarget.addDeploymentProcessor("weld", Phase.STRUCTURE, 2585, (DeploymentUnitProcessor)jbossAllParsers);
                processorTarget.addDeploymentProcessor("weld", Phase.PARSE, 7169, (DeploymentUnitProcessor)new WeldConfigurationProcessor(requireBeanDescriptor, nonPortableMode, developmentMode, legacyEmptyBeansXmlTreatment));
                processorTarget.addDeploymentProcessor("weld", Phase.PARSE, 10768, (DeploymentUnitProcessor)new CdiAnnotationProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.PARSE, 10880, (DeploymentUnitProcessor)new BeanDefiningAnnotationProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.PARSE, 11008, (DeploymentUnitProcessor)new BeansXmlProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.PARSE, 11264, (DeploymentUnitProcessor)new WeldImplicitDeploymentProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.DEPENDENCIES, 2560, (DeploymentUnitProcessor)new WeldDependencyProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 1792, (DeploymentUnitProcessor)new WebIntegrationProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 1920, (DeploymentUnitProcessor)new DevelopmentModeProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 3328, (DeploymentUnitProcessor)new BeanArchiveProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 3408, (DeploymentUnitProcessor)new ExternalBeanArchiveProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 3584, (DeploymentUnitProcessor)new WeldPortableExtensionProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 3856, (DeploymentUnitProcessor)new EarApplicationScopedObserverMethodProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.POST_MODULE, 2048, (DeploymentUnitProcessor)new WeldComponentIntegrationProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.INSTALL, 6912, (DeploymentUnitProcessor)new WeldDeploymentProcessor(WeldSubsystemAdd.this.checkJtsEnabled(context)));
                processorTarget.addDeploymentProcessor("weld", Phase.INSTALL, 7168, (DeploymentUnitProcessor)new WeldBeanManagerServiceProcessor());
                processorTarget.addDeploymentProcessor("weld", Phase.CLEANUP, 511, (DeploymentUnitProcessor)new WeldDeploymentCleanupProcessor());
                ServiceLoader<DeploymentUnitProcessorProvider> processorProviders = ServiceLoader.load(DeploymentUnitProcessorProvider.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldSubsystemAdd.class));
                for (DeploymentUnitProcessorProvider provider : processorProviders) {
                    processorTarget.addDeploymentProcessor("weld", provider.getPhase(), provider.getPriority(), provider.getProcessor());
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.getServiceTarget().addService(TCCLSingletonService.SERVICE_NAME).setInstance((Service)new TCCLSingletonService()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceBuilder builder = context.getServiceTarget().addService(WeldExecutorServices.SERVICE_NAME);
        Consumer executorServicesConsumer = builder.provides(new ServiceName[]{WeldExecutorServices.SERVICE_NAME});
        builder.setInstance((Service)new WeldExecutorServices(executorServicesConsumer, threadPoolSize));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private boolean checkJtsEnabled(OperationContext context) {
        try {
            ModelNode jtsNode = context.readResourceFromRoot(PathAddress.pathAddress((String)"subsystem", (String)"transactions"), false).getModel().get("jts");
            return jtsNode.isDefined() ? jtsNode.asBoolean() : false;
        }
        catch (Resource.NoSuchResourceException ex) {
            return false;
        }
    }
}

