/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.sso.hotrod;

import java.util.function.Consumer;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.client.service.RemoteCacheServiceConfigurator;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactory;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactoryConfiguration;
import org.wildfly.extension.clustering.web.sso.hotrod.HotRodSSOManagementConfiguration;

public class HotRodSSOManagerFactoryServiceConfigurator<A, D, S>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
HotRodSSOManagerFactoryConfiguration {
    private final String name;
    private final HotRodSSOManagementConfiguration config;
    private final CapabilityServiceConfigurator configurator;
    private volatile SupplierDependency<RemoteCache<?, ?>> cache;

    public HotRodSSOManagerFactoryServiceConfigurator(HotRodSSOManagementConfiguration config, String name) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "sso", name}));
        this.name = name;
        this.config = config;
        String configurationName = this.config.getConfigurationName();
        final String templateName = configurationName != null ? configurationName : DefaultTemplate.DIST_SYNC.getTemplateName();
        this.configurator = new RemoteCacheServiceConfigurator(this.getServiceName().append(new String[]{"cache"}), this.config.getContainerName(), this.name, (Consumer)new Consumer<RemoteCacheConfigurationBuilder>(){

            @Override
            public void accept(RemoteCacheConfigurationBuilder builder) {
                builder.forceReturnValues(false).nearCacheMode(NearCacheMode.INVALIDATED).templateName(templateName).transactionMode(TransactionMode.NONE);
            }
        });
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.cache = new ServiceSupplierDependency(this.configurator.configure(support).getServiceName());
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = this.cache.register(builder).provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)factory, (Object)new HotRodSSOManagerFactory((HotRodSSOManagerFactoryConfiguration)this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public <K, V> RemoteCache<K, V> getRemoteCache() {
        return (RemoteCache)this.cache.get();
    }
}

