/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.core.management.logging.CoreManagementLogger;

public class CoreManagementLogger_$logger
extends DelegatingBasicLogger
implements CoreManagementLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CoreManagementLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public CoreManagementLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String processStateInitError$str() {
        return "WFLYCM0002: Error initializing the process state listener %s";
    }

    @Override
    public final String processStateInitError(Throwable t, String name) {
        return String.format(this.getLoggingLocale(), this.processStateInitError$str(), name);
    }

    @Override
    public final void processStateInvokationError(Throwable t, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.processStateInvokationError$str(), (Object)name);
    }

    protected String processStateInvokationError$str() {
        return "WFLYCM0003: Error invoking the process state listener %s";
    }

    @Override
    public final void processStateTimeoutError(Throwable t, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.processStateTimeoutError$str(), (Object)name);
    }

    protected String processStateTimeoutError$str() {
        return "WFLYCM0004: The process state listener %s took to much time to complete.";
    }

    @Override
    public final void processStateCleanupError(Throwable t, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.processStateCleanupError$str(), (Object)name);
    }

    protected String processStateCleanupError$str() {
        return "WFLYCM0005: Error cleaning up for the process state listener %s";
    }

    protected String errorToLoadModule$str() {
        return "WFLYCM0006: Error to load module %s";
    }

    @Override
    public final OperationFailedException errorToLoadModule(String moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.errorToLoadModule$str(), moduleID));
        CoreManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String errorToLoadModuleClass$str() {
        return "WFLYCM0007: Error to load class %s from module %s";
    }

    @Override
    public final OperationFailedException errorToLoadModuleClass(String className, String moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.errorToLoadModuleClass$str(), className, moduleID));
        CoreManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorToInstantiateClassInstanceFromModule$str() {
        return "WFLYCM0008: Error to instantiate instance of class %s from module %s";
    }

    @Override
    public final OperationFailedException errorToInstantiateClassInstanceFromModule(String className, String moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.errorToInstantiateClassInstanceFromModule$str(), className, moduleID));
        CoreManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

