/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.impl.util;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.aesh.command.impl.converter.FileConverter;
import org.aesh.io.Resource;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.utils.Config;

public class FileLister {
    private final String token;
    private final Resource cwd;
    private static final Logger LOGGER = LoggerUtil.getLogger((String)FileLister.class.getName());

    public FileLister(String token, Resource cwd) {
        if (token == null) {
            throw new IllegalArgumentException("Incoming directory cannot be null");
        }
        if (cwd == null) {
            throw new IllegalArgumentException("Current working directory cannot be null");
        }
        this.token = Parser.switchEscapedSpacesToSpacesInWord((String)token);
        this.cwd = cwd;
    }

    public String toString() {
        return "FileLister{token='" + this.token + '\'' + ", cwd=" + this.cwd + '}';
    }

    public int findMatchingDirectories(List<String> candidates) {
        int result = this.getCandidates(this.token, candidates);
        Collections.sort(candidates);
        this.postProcess(this.token, candidates);
        if (candidates.size() == 1) {
            candidates.set(0, FileLister.escapeQuotes(candidates.get(0)));
        }
        return result;
    }

    private int getCandidates(String buffer, List<String> candidates) {
        String translated = FileConverter.translatePath(this.cwd.getAbsolutePath(), buffer);
        File f = new File(translated);
        File dir = translated.endsWith(File.separator) ? f : f.getParentFile();
        File[] entries = dir == null ? new File[]{} : dir.listFiles();
        return this.matchFiles(buffer, translated, entries, candidates);
    }

    private int matchFiles(String buffer, String translated, File[] entries, List<String> candidates) {
        if (entries == null) {
            return -1;
        }
        boolean isDirectory = false;
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getAbsolutePath().startsWith(translated)) continue;
            isDirectory = entries[i].isDirectory();
            if (isDirectory) {
                candidates.add(entries[i].getName() + File.separator);
                continue;
            }
            candidates.add(entries[i].getName());
        }
        int index = buffer.lastIndexOf(File.separatorChar) + 1;
        return index;
    }

    private static String escapeQuotes(String name) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '\"') {
                escaped.append('\\');
            }
            escaped.append(ch);
        }
        return escaped.toString();
    }

    void postProcess(String buffer, List<String> candidates) {
        if (candidates.size() == 1) {
            String candidate = candidates.get(0);
            if (!buffer.contains(File.separator) && buffer.startsWith("~")) {
                candidate = "~" + candidate;
            }
            candidates.set(0, candidate);
        } else if (candidates.isEmpty() && Config.isWindows() && buffer.length() == 2 && buffer.endsWith(":")) {
            candidates.add(buffer + File.separator);
        }
    }
}

